<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SENDC ServiceType
 * @subpackage Services
 */
class SENDC extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SEND_CommandToMobile
     * Meta informations extracted from the WSDL
     * - documentation: Envía un comando al móvil.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SEND_CommandToMobile $parameters
     * @return \StructType\SEND_CommandToMobileResponse|bool
     */
    public function SEND_CommandToMobile(\StructType\SEND_CommandToMobile $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SEND_CommandToMobile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SEND_CommandToMobileResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
