<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETG ServiceType
 * @subpackage Services
 */
class GETG extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_GeoFenceLog
     * Meta informations extracted from the WSDL
     * - documentation: Permite ver todos los moviles que han reportado un evento (entrada o salida) en geoCerca junto con los puntos de referencia asociados, yyyy-mm-dd hh:mm:ss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_GeoFenceLog $parameters
     * @return \StructType\GET_GeoFenceLogResponse|bool
     */
    public function GET_GeoFenceLog(\StructType\GET_GeoFenceLog $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_GeoFenceLog($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_GeofenceWithPoints
     * Meta informations extracted from the WSDL
     * - documentation: Retorna la lista de geocercas del un grupo con los puntos de referencia localizados dentro de éstas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_GeofenceWithPoints $parameters
     * @return \StructType\GET_GeofenceWithPointsResponse|bool
     */
    public function GET_GeofenceWithPoints(\StructType\GET_GeofenceWithPoints $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_GeofenceWithPoints($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_GroupGeofences
     * Meta informations extracted from the WSDL
     * - documentation: Devuelve el listado de las geocercas activas de un grupo. Si no se especifica un grupo devuelve las geocercas grupales la flota.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_GroupGeofences $parameters
     * @return \StructType\GET_GroupGeofencesResponse|bool
     */
    public function GET_GroupGeofences(\StructType\GET_GroupGeofences $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_GroupGeofences($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_GeoCoding
     * Meta informations extracted from the WSDL
     * - documentation: ATENCION: No implemente esta función sin consultar a SONAR AVL. Devuelve las coordenadas geográficas de una dirección en un listado con las coincidencias encontradas. Esta función es de uso restringido
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_GeoCoding $parameters
     * @return \StructType\GET_GeoCodingResponse|bool
     */
    public function GET_GeoCoding(\StructType\GET_GeoCoding $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_GeoCoding($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_GeoCodingPOI
     * Meta informations extracted from the WSDL
     * - documentation: ATENCION: No implemente esta función sin consultar a SONAR AVL. Devuelve las coordenadas geográficas de un punto de interes en un listado con las coincidencias encontradas. Esta función es de uso restringido
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_GeoCodingPOI $parameters
     * @return \StructType\GET_GeoCodingPOIResponse|bool
     */
    public function GET_GeoCodingPOI(\StructType\GET_GeoCodingPOI $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_GeoCodingPOI($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_GeoCodingUSERPOI
     * Meta informations extracted from the WSDL
     * - documentation: ATENCION: No implemente esta función sin consultar a SONAR AVL. Devuelve las coordenadas geográficas de un punto de interes creados por los usuarios en la flota. Esta función es de uso restringido
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_GeoCodingUSERPOI $parameters
     * @return \StructType\GET_GeoCodingUSERPOIResponse|bool
     */
    public function GET_GeoCodingUSERPOI(\StructType\GET_GeoCodingUSERPOI $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_GeoCodingUSERPOI($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_GeolocatedPassengerHistory
     * Meta informations extracted from the WSDL
     * - documentation: Devuelve el historial de contadores geolocalizados de pasajeros de un vehículo. datetime_init y datetime_end se dan en el formato yyyy-mm-dd hh:mm:ss y en UTC
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_GeolocatedPassengerHistory $parameters
     * @return \StructType\GET_GeolocatedPassengerHistoryResponse|bool
     */
    public function GET_GeolocatedPassengerHistory(\StructType\GET_GeolocatedPassengerHistory $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_GeolocatedPassengerHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_GeoCodingPOIResponse|\StructType\GET_GeoCodingResponse|\StructType\GET_GeoCodingUSERPOIResponse|\StructType\GET_GeoFenceLogResponse|\StructType\GET_GeofenceWithPointsResponse|\StructType\GET_GeolocatedPassengerHistoryResponse|\StructType\GET_GroupGeofencesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
