<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGroupGeofence ArrayType
 * @subpackage Arrays
 */
class ArrayOfGroupGeofence extends AbstractStructArrayBase
{
    /**
     * The GroupGeofence
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GroupGeofence[]
     */
    public $GroupGeofence;
    /**
     * Constructor method for ArrayOfGroupGeofence
     * @uses ArrayOfGroupGeofence::setGroupGeofence()
     * @param \StructType\GroupGeofence[] $groupGeofence
     */
    public function __construct(array $groupGeofence = array())
    {
        $this
            ->setGroupGeofence($groupGeofence);
    }
    /**
     * Get GroupGeofence value
     * @return \StructType\GroupGeofence[]|null
     */
    public function getGroupGeofence()
    {
        return $this->GroupGeofence;
    }
    /**
     * Set GroupGeofence value
     * @throws \InvalidArgumentException
     * @param \StructType\GroupGeofence[] $groupGeofence
     * @return \ArrayType\ArrayOfGroupGeofence
     */
    public function setGroupGeofence(array $groupGeofence = array())
    {
        foreach ($groupGeofence as $arrayOfGroupGeofenceGroupGeofenceItem) {
            // validation for constraint: itemType
            if (!$arrayOfGroupGeofenceGroupGeofenceItem instanceof \StructType\GroupGeofence) {
                throw new \InvalidArgumentException(sprintf('The GroupGeofence property can only contain items of \StructType\GroupGeofence, "%s" given', is_object($arrayOfGroupGeofenceGroupGeofenceItem) ? get_class($arrayOfGroupGeofenceGroupGeofenceItem) : gettype($arrayOfGroupGeofenceGroupGeofenceItem)), __LINE__);
            }
        }
        $this->GroupGeofence = $groupGeofence;
        return $this;
    }
    /**
     * Add item to GroupGeofence value
     * @throws \InvalidArgumentException
     * @param \StructType\GroupGeofence $item
     * @return \ArrayType\ArrayOfGroupGeofence
     */
    public function addToGroupGeofence(\StructType\GroupGeofence $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GroupGeofence) {
            throw new \InvalidArgumentException(sprintf('The GroupGeofence property can only contain items of \StructType\GroupGeofence, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GroupGeofence[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\GroupGeofence|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\GroupGeofence|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\GroupGeofence|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\GroupGeofence|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\GroupGeofence|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string GroupGeofence
     */
    public function getAttributeName()
    {
        return 'GroupGeofence';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfGroupGeofence
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
