<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETZ ServiceType
 * @subpackage Services
 */
class GETZ extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_ZonesList
     * Meta informations extracted from the WSDL
     * - documentation: Devuelve el listado de zonas disponibles para la flota.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_ZonesList $parameters
     * @return \StructType\GET_ZonesListResponse|bool
     */
    public function GET_ZonesList(\StructType\GET_ZonesList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_ZonesList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_ZonesListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
