<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETA ServiceType
 * @subpackage Services
 */
class GETA extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_AccountList
     * Meta informations extracted from the WSDL
     * - documentation: para uso interno solamente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_AccountList $parameters
     * @return \StructType\GET_AccountListResponse|bool
     */
    public function GET_AccountList(\StructType\GET_AccountList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_AccountList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_AlertsHistory
     * Meta informations extracted from the WSDL
     * - documentation: Devuelve el historial de alertas de un móvil. UTC_datetime_init y UTC_datetime_end se dan en el formato yyyy-mm-dd hh:mm:ss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_AlertsHistory $parameters
     * @return \StructType\GET_AlertsHistoryResponse|bool
     */
    public function GET_AlertsHistory(\StructType\GET_AlertsHistory $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_AlertsHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_AssignedZonesList
     * Meta informations extracted from the WSDL
     * - documentation: Devuelve el listado de zonas asignadas a un movil.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_AssignedZonesList $parameters
     * @return \StructType\GET_AssignedZonesListResponse|bool
     */
    public function GET_AssignedZonesList(\StructType\GET_AssignedZonesList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_AssignedZonesList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_AccountListResponse|\StructType\GET_AlertsHistoryResponse|\StructType\GET_AssignedZonesListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
