<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCANVariables ArrayType
 * @subpackage Arrays
 */
class ArrayOfCANVariables extends AbstractStructArrayBase
{
    /**
     * The CANVariables
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CANVariables[]
     */
    public $CANVariables;
    /**
     * Constructor method for ArrayOfCANVariables
     * @uses ArrayOfCANVariables::setCANVariables()
     * @param \StructType\CANVariables[] $cANVariables
     */
    public function __construct(array $cANVariables = array())
    {
        $this
            ->setCANVariables($cANVariables);
    }
    /**
     * Get CANVariables value
     * @return \StructType\CANVariables[]|null
     */
    public function getCANVariables()
    {
        return $this->CANVariables;
    }
    /**
     * Set CANVariables value
     * @throws \InvalidArgumentException
     * @param \StructType\CANVariables[] $cANVariables
     * @return \ArrayType\ArrayOfCANVariables
     */
    public function setCANVariables(array $cANVariables = array())
    {
        foreach ($cANVariables as $arrayOfCANVariablesCANVariablesItem) {
            // validation for constraint: itemType
            if (!$arrayOfCANVariablesCANVariablesItem instanceof \StructType\CANVariables) {
                throw new \InvalidArgumentException(sprintf('The CANVariables property can only contain items of \StructType\CANVariables, "%s" given', is_object($arrayOfCANVariablesCANVariablesItem) ? get_class($arrayOfCANVariablesCANVariablesItem) : gettype($arrayOfCANVariablesCANVariablesItem)), __LINE__);
            }
        }
        $this->CANVariables = $cANVariables;
        return $this;
    }
    /**
     * Add item to CANVariables value
     * @throws \InvalidArgumentException
     * @param \StructType\CANVariables $item
     * @return \ArrayType\ArrayOfCANVariables
     */
    public function addToCANVariables(\StructType\CANVariables $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CANVariables) {
            throw new \InvalidArgumentException(sprintf('The CANVariables property can only contain items of \StructType\CANVariables, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CANVariables[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CANVariables|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CANVariables|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CANVariables|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CANVariables|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CANVariables|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CANVariables
     */
    public function getAttributeName()
    {
        return 'CANVariables';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCANVariables
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
