<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEventLocation ArrayType
 * @subpackage Arrays
 */
class ArrayOfEventLocation extends AbstractStructArrayBase
{
    /**
     * The EventLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EventLocation[]
     */
    public $EventLocation;
    /**
     * Constructor method for ArrayOfEventLocation
     * @uses ArrayOfEventLocation::setEventLocation()
     * @param \StructType\EventLocation[] $eventLocation
     */
    public function __construct(array $eventLocation = array())
    {
        $this
            ->setEventLocation($eventLocation);
    }
    /**
     * Get EventLocation value
     * @return \StructType\EventLocation[]|null
     */
    public function getEventLocation()
    {
        return $this->EventLocation;
    }
    /**
     * Set EventLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\EventLocation[] $eventLocation
     * @return \ArrayType\ArrayOfEventLocation
     */
    public function setEventLocation(array $eventLocation = array())
    {
        foreach ($eventLocation as $arrayOfEventLocationEventLocationItem) {
            // validation for constraint: itemType
            if (!$arrayOfEventLocationEventLocationItem instanceof \StructType\EventLocation) {
                throw new \InvalidArgumentException(sprintf('The EventLocation property can only contain items of \StructType\EventLocation, "%s" given', is_object($arrayOfEventLocationEventLocationItem) ? get_class($arrayOfEventLocationEventLocationItem) : gettype($arrayOfEventLocationEventLocationItem)), __LINE__);
            }
        }
        $this->EventLocation = $eventLocation;
        return $this;
    }
    /**
     * Add item to EventLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\EventLocation $item
     * @return \ArrayType\ArrayOfEventLocation
     */
    public function addToEventLocation(\StructType\EventLocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EventLocation) {
            throw new \InvalidArgumentException(sprintf('The EventLocation property can only contain items of \StructType\EventLocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EventLocation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EventLocation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EventLocation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EventLocation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EventLocation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EventLocation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EventLocation
     */
    public function getAttributeName()
    {
        return 'EventLocation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEventLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
