<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MobileGroup StructType
 * @subpackage Structs
 */
class MobileGroup extends AbstractStructBase
{
    /**
     * The gId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $gId;
    /**
     * The gName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $gName;
    /**
     * The mList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfMobile
     */
    public $mList;
    /**
     * Constructor method for MobileGroup
     * @uses MobileGroup::setGId()
     * @uses MobileGroup::setGName()
     * @uses MobileGroup::setMList()
     * @param int $gId
     * @param string $gName
     * @param \ArrayType\ArrayOfMobile $mList
     */
    public function __construct($gId = null, $gName = null, \ArrayType\ArrayOfMobile $mList = null)
    {
        $this
            ->setGId($gId)
            ->setGName($gName)
            ->setMList($mList);
    }
    /**
     * Get gId value
     * @return int
     */
    public function getGId()
    {
        return $this->gId;
    }
    /**
     * Set gId value
     * @param int $gId
     * @return \StructType\MobileGroup
     */
    public function setGId($gId = null)
    {
        // validation for constraint: int
        if (!is_null($gId) && !is_numeric($gId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($gId)), __LINE__);
        }
        $this->gId = $gId;
        return $this;
    }
    /**
     * Get gName value
     * @return string|null
     */
    public function getGName()
    {
        return $this->gName;
    }
    /**
     * Set gName value
     * @param string $gName
     * @return \StructType\MobileGroup
     */
    public function setGName($gName = null)
    {
        // validation for constraint: string
        if (!is_null($gName) && !is_string($gName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gName)), __LINE__);
        }
        $this->gName = $gName;
        return $this;
    }
    /**
     * Get mList value
     * @return \ArrayType\ArrayOfMobile|null
     */
    public function getMList()
    {
        return $this->mList;
    }
    /**
     * Set mList value
     * @param \ArrayType\ArrayOfMobile $mList
     * @return \StructType\MobileGroup
     */
    public function setMList(\ArrayType\ArrayOfMobile $mList = null)
    {
        $this->mList = $mList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MobileGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
