<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MobileDistance StructType
 * @subpackage Structs
 */
class MobileDistance extends AbstractStructBase
{
    /**
     * The mProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $mProfile;
    /**
     * The mDistance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $mDistance;
    /**
     * The mId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mId;
    /**
     * The mDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mDescription;
    /**
     * The mLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEventLocation
     */
    public $mLocation;
    /**
     * Constructor method for MobileDistance
     * @uses MobileDistance::setMProfile()
     * @uses MobileDistance::setMDistance()
     * @uses MobileDistance::setMId()
     * @uses MobileDistance::setMDescription()
     * @uses MobileDistance::setMLocation()
     * @param int $mProfile
     * @param float $mDistance
     * @param string $mId
     * @param string $mDescription
     * @param \ArrayType\ArrayOfEventLocation $mLocation
     */
    public function __construct($mProfile = null, $mDistance = null, $mId = null, $mDescription = null, \ArrayType\ArrayOfEventLocation $mLocation = null)
    {
        $this
            ->setMProfile($mProfile)
            ->setMDistance($mDistance)
            ->setMId($mId)
            ->setMDescription($mDescription)
            ->setMLocation($mLocation);
    }
    /**
     * Get mProfile value
     * @return int
     */
    public function getMProfile()
    {
        return $this->mProfile;
    }
    /**
     * Set mProfile value
     * @param int $mProfile
     * @return \StructType\MobileDistance
     */
    public function setMProfile($mProfile = null)
    {
        // validation for constraint: int
        if (!is_null($mProfile) && !is_numeric($mProfile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($mProfile)), __LINE__);
        }
        $this->mProfile = $mProfile;
        return $this;
    }
    /**
     * Get mDistance value
     * @return float
     */
    public function getMDistance()
    {
        return $this->mDistance;
    }
    /**
     * Set mDistance value
     * @param float $mDistance
     * @return \StructType\MobileDistance
     */
    public function setMDistance($mDistance = null)
    {
        $this->mDistance = $mDistance;
        return $this;
    }
    /**
     * Get mId value
     * @return string|null
     */
    public function getMId()
    {
        return $this->mId;
    }
    /**
     * Set mId value
     * @param string $mId
     * @return \StructType\MobileDistance
     */
    public function setMId($mId = null)
    {
        // validation for constraint: string
        if (!is_null($mId) && !is_string($mId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mId)), __LINE__);
        }
        $this->mId = $mId;
        return $this;
    }
    /**
     * Get mDescription value
     * @return string|null
     */
    public function getMDescription()
    {
        return $this->mDescription;
    }
    /**
     * Set mDescription value
     * @param string $mDescription
     * @return \StructType\MobileDistance
     */
    public function setMDescription($mDescription = null)
    {
        // validation for constraint: string
        if (!is_null($mDescription) && !is_string($mDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mDescription)), __LINE__);
        }
        $this->mDescription = $mDescription;
        return $this;
    }
    /**
     * Get mLocation value
     * @return \ArrayType\ArrayOfEventLocation|null
     */
    public function getMLocation()
    {
        return $this->mLocation;
    }
    /**
     * Set mLocation value
     * @param \ArrayType\ArrayOfEventLocation $mLocation
     * @return \StructType\MobileDistance
     */
    public function setMLocation(\ArrayType\ArrayOfEventLocation $mLocation = null)
    {
        $this->mLocation = $mLocation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MobileDistance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
