<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SETZ ServiceType
 * @subpackage Services
 */
class SETZ extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SET_ZoneAssign
     * Meta informations extracted from the WSDL
     * - documentation: Asigna una zona de control a un movil.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SET_ZoneAssign $parameters
     * @return \StructType\SET_ZoneAssignResponse|bool
     */
    public function SET_ZoneAssign(\StructType\SET_ZoneAssign $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SET_ZoneAssign($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SET_ZoneUnAssign
     * Meta informations extracted from the WSDL
     * - documentation: Quita la asignación de una zona de control a un movil.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SET_ZoneUnAssign $parameters
     * @return \StructType\SET_ZoneUnAssignResponse|bool
     */
    public function SET_ZoneUnAssign(\StructType\SET_ZoneUnAssign $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SET_ZoneUnAssign($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SET_ZoneAssignResponse|\StructType\SET_ZoneUnAssignResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
