<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SETSATM ServiceType
 * @subpackage Services
 */
class SETSATM extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SET_SATMobileStatus
     * Meta informations extracted from the WSDL
     * - documentation: Establece el estado SAT a un movil.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SET_SATMobileStatus $parameters
     * @return \StructType\SET_SATMobileStatusResponse|bool
     */
    public function SET_SATMobileStatus(\StructType\SET_SATMobileStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SET_SATMobileStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SET_SATMobileStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
