<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SENDM ServiceType
 * @subpackage Services
 */
class SENDM extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SEND_MsgToMobile
     * Meta informations extracted from the WSDL
     * - documentation: Envía un mensaje al móvil. Requiere que el móvil tenga un dispositivo que permita la recepción de mensajes.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SEND_MsgToMobile $parameters
     * @return \StructType\SEND_MsgToMobileResponse|bool
     */
    public function SEND_MsgToMobile(\StructType\SEND_MsgToMobile $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SEND_MsgToMobile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SEND_MsgToMobileResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
