<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETU ServiceType
 * @subpackage Services
 */
class GETU extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_UserProfile
     * Meta informations extracted from the WSDL
     * - documentation: para uso interno solamente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_UserProfile $parameters
     * @return \StructType\GET_UserProfileResponse|bool
     */
    public function GET_UserProfile(\StructType\GET_UserProfile $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_UserProfile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_UserProfileResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
