<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETD ServiceType
 * @subpackage Services
 */
class GETD extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_Drivers
     * Meta informations extracted from the WSDL
     * - documentation: Devuelve la configuracion de los conductores de la flota. Si no se especifica un conductor (DrvId) devuelve todos.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_Drivers $parameters
     * @return \StructType\GET_DriversResponse|bool
     */
    public function GET_Drivers(\StructType\GET_Drivers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_Drivers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_Drivers_v2
     * Meta informations extracted from the WSDL
     * - documentation: Devuelve la configuracion de los conductores de la flota. Si no se especifica un conductor (DrvId o DrvDoc) devuelve todos.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_Drivers_v2 $parameters
     * @return \StructType\GET_Drivers_v2Response|bool
     */
    public function GET_Drivers_v2(\StructType\GET_Drivers_v2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_Drivers_v2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_DriversHistory
     * Meta informations extracted from the WSDL
     * - documentation: Devuelve el historial de registro de conductores de un móvil. UTC_datetime_init y UTC_datetime_end se dan en el formato yyyy-mm-dd hh:mm:ss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_DriversHistory $parameters
     * @return \StructType\GET_DriversHistoryResponse|bool
     */
    public function GET_DriversHistory(\StructType\GET_DriversHistory $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_DriversHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_DriversHistoryResponse|\StructType\GET_DriversResponse|\StructType\GET_Drivers_v2Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
