<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMobileOperationInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfMobileOperationInfo extends AbstractStructArrayBase
{
    /**
     * The MobileOperationInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MobileOperationInfo[]
     */
    public $MobileOperationInfo;
    /**
     * Constructor method for ArrayOfMobileOperationInfo
     * @uses ArrayOfMobileOperationInfo::setMobileOperationInfo()
     * @param \StructType\MobileOperationInfo[] $mobileOperationInfo
     */
    public function __construct(array $mobileOperationInfo = array())
    {
        $this
            ->setMobileOperationInfo($mobileOperationInfo);
    }
    /**
     * Get MobileOperationInfo value
     * @return \StructType\MobileOperationInfo[]|null
     */
    public function getMobileOperationInfo()
    {
        return $this->MobileOperationInfo;
    }
    /**
     * Set MobileOperationInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\MobileOperationInfo[] $mobileOperationInfo
     * @return \ArrayType\ArrayOfMobileOperationInfo
     */
    public function setMobileOperationInfo(array $mobileOperationInfo = array())
    {
        foreach ($mobileOperationInfo as $arrayOfMobileOperationInfoMobileOperationInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfMobileOperationInfoMobileOperationInfoItem instanceof \StructType\MobileOperationInfo) {
                throw new \InvalidArgumentException(sprintf('The MobileOperationInfo property can only contain items of \StructType\MobileOperationInfo, "%s" given', is_object($arrayOfMobileOperationInfoMobileOperationInfoItem) ? get_class($arrayOfMobileOperationInfoMobileOperationInfoItem) : gettype($arrayOfMobileOperationInfoMobileOperationInfoItem)), __LINE__);
            }
        }
        $this->MobileOperationInfo = $mobileOperationInfo;
        return $this;
    }
    /**
     * Add item to MobileOperationInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\MobileOperationInfo $item
     * @return \ArrayType\ArrayOfMobileOperationInfo
     */
    public function addToMobileOperationInfo(\StructType\MobileOperationInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MobileOperationInfo) {
            throw new \InvalidArgumentException(sprintf('The MobileOperationInfo property can only contain items of \StructType\MobileOperationInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MobileOperationInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MobileOperationInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MobileOperationInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MobileOperationInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MobileOperationInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MobileOperationInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MobileOperationInfo
     */
    public function getAttributeName()
    {
        return 'MobileOperationInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfMobileOperationInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
