<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccountInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfAccountInfo extends AbstractStructArrayBase
{
    /**
     * The AccountInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AccountInfo[]
     */
    public $AccountInfo;
    /**
     * Constructor method for ArrayOfAccountInfo
     * @uses ArrayOfAccountInfo::setAccountInfo()
     * @param \StructType\AccountInfo[] $accountInfo
     */
    public function __construct(array $accountInfo = array())
    {
        $this
            ->setAccountInfo($accountInfo);
    }
    /**
     * Get AccountInfo value
     * @return \StructType\AccountInfo[]|null
     */
    public function getAccountInfo()
    {
        return $this->AccountInfo;
    }
    /**
     * Set AccountInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountInfo[] $accountInfo
     * @return \ArrayType\ArrayOfAccountInfo
     */
    public function setAccountInfo(array $accountInfo = array())
    {
        foreach ($accountInfo as $arrayOfAccountInfoAccountInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccountInfoAccountInfoItem instanceof \StructType\AccountInfo) {
                throw new \InvalidArgumentException(sprintf('The AccountInfo property can only contain items of \StructType\AccountInfo, "%s" given', is_object($arrayOfAccountInfoAccountInfoItem) ? get_class($arrayOfAccountInfoAccountInfoItem) : gettype($arrayOfAccountInfoAccountInfoItem)), __LINE__);
            }
        }
        $this->AccountInfo = $accountInfo;
        return $this;
    }
    /**
     * Add item to AccountInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountInfo $item
     * @return \ArrayType\ArrayOfAccountInfo
     */
    public function addToAccountInfo(\StructType\AccountInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccountInfo) {
            throw new \InvalidArgumentException(sprintf('The AccountInfo property can only contain items of \StructType\AccountInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AccountInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AccountInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AccountInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AccountInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AccountInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccountInfo
     */
    public function getAttributeName()
    {
        return 'AccountInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAccountInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
