<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QuickMessageLogResponse StructType
 * @subpackage Structs
 */
class QuickMessageLogResponse extends AbstractStructBase
{
    /**
     * The error_code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $error_code;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The QuickMessageList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfQuickMessageLog
     */
    public $QuickMessageList;
    /**
     * Constructor method for QuickMessageLogResponse
     * @uses QuickMessageLogResponse::setError_code()
     * @uses QuickMessageLogResponse::setStatus()
     * @uses QuickMessageLogResponse::setDescription()
     * @uses QuickMessageLogResponse::setQuickMessageList()
     * @param int $error_code
     * @param string $status
     * @param string $description
     * @param \ArrayType\ArrayOfQuickMessageLog $quickMessageList
     */
    public function __construct($error_code = null, $status = null, $description = null, \ArrayType\ArrayOfQuickMessageLog $quickMessageList = null)
    {
        $this
            ->setError_code($error_code)
            ->setStatus($status)
            ->setDescription($description)
            ->setQuickMessageList($quickMessageList);
    }
    /**
     * Get error_code value
     * @return int
     */
    public function getError_code()
    {
        return $this->error_code;
    }
    /**
     * Set error_code value
     * @param int $error_code
     * @return \StructType\QuickMessageLogResponse
     */
    public function setError_code($error_code = null)
    {
        // validation for constraint: int
        if (!is_null($error_code) && !is_numeric($error_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($error_code)), __LINE__);
        }
        $this->error_code = $error_code;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\QuickMessageLogResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\QuickMessageLogResponse
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get QuickMessageList value
     * @return \ArrayType\ArrayOfQuickMessageLog|null
     */
    public function getQuickMessageList()
    {
        return $this->QuickMessageList;
    }
    /**
     * Set QuickMessageList value
     * @param \ArrayType\ArrayOfQuickMessageLog $quickMessageList
     * @return \StructType\QuickMessageLogResponse
     */
    public function setQuickMessageList(\ArrayType\ArrayOfQuickMessageLog $quickMessageList = null)
    {
        $this->QuickMessageList = $quickMessageList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QuickMessageLogResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
