<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MobileCommand StructType
 * @subpackage Structs
 */
class MobileCommand extends AbstractStructBase
{
    /**
     * The cId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cId;
    /**
     * The cmId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cmId;
    /**
     * The cname
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cname;
    /**
     * Constructor method for MobileCommand
     * @uses MobileCommand::setCId()
     * @uses MobileCommand::setCmId()
     * @uses MobileCommand::setCname()
     * @param string $cId
     * @param string $cmId
     * @param string $cname
     */
    public function __construct($cId = null, $cmId = null, $cname = null)
    {
        $this
            ->setCId($cId)
            ->setCmId($cmId)
            ->setCname($cname);
    }
    /**
     * Get cId value
     * @return string|null
     */
    public function getCId()
    {
        return $this->cId;
    }
    /**
     * Set cId value
     * @param string $cId
     * @return \StructType\MobileCommand
     */
    public function setCId($cId = null)
    {
        // validation for constraint: string
        if (!is_null($cId) && !is_string($cId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cId)), __LINE__);
        }
        $this->cId = $cId;
        return $this;
    }
    /**
     * Get cmId value
     * @return string|null
     */
    public function getCmId()
    {
        return $this->cmId;
    }
    /**
     * Set cmId value
     * @param string $cmId
     * @return \StructType\MobileCommand
     */
    public function setCmId($cmId = null)
    {
        // validation for constraint: string
        if (!is_null($cmId) && !is_string($cmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cmId)), __LINE__);
        }
        $this->cmId = $cmId;
        return $this;
    }
    /**
     * Get cname value
     * @return string|null
     */
    public function getCname()
    {
        return $this->cname;
    }
    /**
     * Set cname value
     * @param string $cname
     * @return \StructType\MobileCommand
     */
    public function setCname($cname = null)
    {
        // validation for constraint: string
        if (!is_null($cname) && !is_string($cname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cname)), __LINE__);
        }
        $this->cname = $cname;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MobileCommand
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
