<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SETI ServiceType
 * @subpackage Services
 */
class SETI extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SET_ItAssign
     * Meta informations extracted from the WSDL
     * - documentation: Asigna un itinerario a un móvil y a un conductor. UTC_datetime se da en el formato yyyy-mm-dd hh:mm:ss, si se deja en blanco toma la hora actual
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SET_ItAssign $parameters
     * @return \StructType\SET_ItAssignResponse|bool
     */
    public function SET_ItAssign(\StructType\SET_ItAssign $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SET_ItAssign($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SET_ItAssign_v2
     * Meta informations extracted from the WSDL
     * - documentation: Asigna un itinerario a un móvil y a un conductor. UTC_datetime se da en el formato yyyy-mm-dd hh:mm:ss, si se deja en blanco toma la hora actual
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SET_ItAssign_v2 $parameters
     * @return \StructType\SET_ItAssign_v2Response|bool
     */
    public function SET_ItAssign_v2(\StructType\SET_ItAssign_v2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SET_ItAssign_v2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SET_ItCancel
     * Meta informations extracted from the WSDL
     * - documentation: Cancela la asignación de un itinerario.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SET_ItCancel $parameters
     * @return \StructType\SET_ItCancelResponse|bool
     */
    public function SET_ItCancel(\StructType\SET_ItCancel $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SET_ItCancel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SET_ItAssignResponse|\StructType\SET_ItAssign_v2Response|\StructType\SET_ItCancelResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
