<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETCAN ServiceType
 * @subpackage Services
 */
class GETCAN extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_CAN_variables
     * Meta informations extracted from the WSDL
     * - documentation: Devuelve el listado de las variables configuradas con el CAN BUS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_CAN_variables $parameters
     * @return \StructType\GET_CAN_variablesResponse|bool
     */
    public function GET_CAN_variables(\StructType\GET_CAN_variables $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_CAN_variables($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_CAN_variablesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
