<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMobile ArrayType
 * @subpackage Arrays
 */
class ArrayOfMobile extends AbstractStructArrayBase
{
    /**
     * The Mobile
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Mobile[]
     */
    public $Mobile;
    /**
     * Constructor method for ArrayOfMobile
     * @uses ArrayOfMobile::setMobile()
     * @param \StructType\Mobile[] $mobile
     */
    public function __construct(array $mobile = array())
    {
        $this
            ->setMobile($mobile);
    }
    /**
     * Get Mobile value
     * @return \StructType\Mobile[]|null
     */
    public function getMobile()
    {
        return $this->Mobile;
    }
    /**
     * Set Mobile value
     * @throws \InvalidArgumentException
     * @param \StructType\Mobile[] $mobile
     * @return \ArrayType\ArrayOfMobile
     */
    public function setMobile(array $mobile = array())
    {
        foreach ($mobile as $arrayOfMobileMobileItem) {
            // validation for constraint: itemType
            if (!$arrayOfMobileMobileItem instanceof \StructType\Mobile) {
                throw new \InvalidArgumentException(sprintf('The Mobile property can only contain items of \StructType\Mobile, "%s" given', is_object($arrayOfMobileMobileItem) ? get_class($arrayOfMobileMobileItem) : gettype($arrayOfMobileMobileItem)), __LINE__);
            }
        }
        $this->Mobile = $mobile;
        return $this;
    }
    /**
     * Add item to Mobile value
     * @throws \InvalidArgumentException
     * @param \StructType\Mobile $item
     * @return \ArrayType\ArrayOfMobile
     */
    public function addToMobile(\StructType\Mobile $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Mobile) {
            throw new \InvalidArgumentException(sprintf('The Mobile property can only contain items of \StructType\Mobile, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Mobile[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Mobile|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Mobile|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Mobile|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Mobile|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Mobile|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Mobile
     */
    public function getAttributeName()
    {
        return 'Mobile';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfMobile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
