<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupGeofence StructType
 * @subpackage Structs
 */
class GroupGeofence extends AbstractStructBase
{
    /**
     * The groupID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $groupID;
    /**
     * The g_index
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $g_index;
    /**
     * The g_name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $g_name;
    /**
     * The g_active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $g_active;
    /**
     * Constructor method for GroupGeofence
     * @uses GroupGeofence::setGroupID()
     * @uses GroupGeofence::setG_index()
     * @uses GroupGeofence::setG_name()
     * @uses GroupGeofence::setG_active()
     * @param int $groupID
     * @param int $g_index
     * @param string $g_name
     * @param string $g_active
     */
    public function __construct($groupID = null, $g_index = null, $g_name = null, $g_active = null)
    {
        $this
            ->setGroupID($groupID)
            ->setG_index($g_index)
            ->setG_name($g_name)
            ->setG_active($g_active);
    }
    /**
     * Get groupID value
     * @return int
     */
    public function getGroupID()
    {
        return $this->groupID;
    }
    /**
     * Set groupID value
     * @param int $groupID
     * @return \StructType\GroupGeofence
     */
    public function setGroupID($groupID = null)
    {
        // validation for constraint: int
        if (!is_null($groupID) && !is_numeric($groupID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($groupID)), __LINE__);
        }
        $this->groupID = $groupID;
        return $this;
    }
    /**
     * Get g_index value
     * @return int
     */
    public function getG_index()
    {
        return $this->g_index;
    }
    /**
     * Set g_index value
     * @param int $g_index
     * @return \StructType\GroupGeofence
     */
    public function setG_index($g_index = null)
    {
        // validation for constraint: int
        if (!is_null($g_index) && !is_numeric($g_index)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($g_index)), __LINE__);
        }
        $this->g_index = $g_index;
        return $this;
    }
    /**
     * Get g_name value
     * @return string|null
     */
    public function getG_name()
    {
        return $this->g_name;
    }
    /**
     * Set g_name value
     * @param string $g_name
     * @return \StructType\GroupGeofence
     */
    public function setG_name($g_name = null)
    {
        // validation for constraint: string
        if (!is_null($g_name) && !is_string($g_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($g_name)), __LINE__);
        }
        $this->g_name = $g_name;
        return $this;
    }
    /**
     * Get g_active value
     * @return string|null
     */
    public function getG_active()
    {
        return $this->g_active;
    }
    /**
     * Set g_active value
     * @param string $g_active
     * @return \StructType\GroupGeofence
     */
    public function setG_active($g_active = null)
    {
        // validation for constraint: string
        if (!is_null($g_active) && !is_string($g_active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($g_active)), __LINE__);
        }
        $this->g_active = $g_active;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GroupGeofence
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
