<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Door StructType
 * @subpackage Structs
 */
class Door extends AbstractStructBase
{
    /**
     * The NumDoor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumDoor;
    /**
     * The In
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $In;
    /**
     * The Out
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Out;
    /**
     * Constructor method for Door
     * @uses Door::setNumDoor()
     * @uses Door::setIn()
     * @uses Door::setOut()
     * @param int $numDoor
     * @param int $in
     * @param int $out
     */
    public function __construct($numDoor = null, $in = null, $out = null)
    {
        $this
            ->setNumDoor($numDoor)
            ->setIn($in)
            ->setOut($out);
    }
    /**
     * Get NumDoor value
     * @return int
     */
    public function getNumDoor()
    {
        return $this->NumDoor;
    }
    /**
     * Set NumDoor value
     * @param int $numDoor
     * @return \StructType\Door
     */
    public function setNumDoor($numDoor = null)
    {
        // validation for constraint: int
        if (!is_null($numDoor) && !is_numeric($numDoor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numDoor)), __LINE__);
        }
        $this->NumDoor = $numDoor;
        return $this;
    }
    /**
     * Get In value
     * @return int
     */
    public function getIn()
    {
        return $this->In;
    }
    /**
     * Set In value
     * @param int $in
     * @return \StructType\Door
     */
    public function setIn($in = null)
    {
        // validation for constraint: int
        if (!is_null($in) && !is_numeric($in)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($in)), __LINE__);
        }
        $this->In = $in;
        return $this;
    }
    /**
     * Get Out value
     * @return int
     */
    public function getOut()
    {
        return $this->Out;
    }
    /**
     * Set Out value
     * @param int $out
     * @return \StructType\Door
     */
    public function setOut($out = null)
    {
        // validation for constraint: int
        if (!is_null($out) && !is_numeric($out)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($out)), __LINE__);
        }
        $this->Out = $out;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Door
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
