<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SETD ServiceType
 * @subpackage Services
 */
class SETD extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SET_DeletedAlert
     * Meta informations extracted from the WSDL
     * - documentation: Marca la alerta como borrada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SET_DeletedAlert $parameters
     * @return \StructType\SET_DeletedAlertResponse|bool
     */
    public function SET_DeletedAlert(\StructType\SET_DeletedAlert $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SET_DeletedAlert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SET_Driver
     * Meta informations extracted from the WSDL
     * - documentation: Asigna un conductor a un móvil. Si solo se incluye el mId, se borra la asignación para este movil. Si solo se incluye el DrvId, se borra la asignación para este conductor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SET_Driver $parameters
     * @return \StructType\SET_DriverResponse|bool
     */
    public function SET_Driver(\StructType\SET_Driver $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SET_Driver($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SET_DeletedAlertResponse|\StructType\SET_DriverResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
