<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeofenceEventLog StructType
 * @subpackage Structs
 */
class GeofenceEventLog extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The GeoId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GeoId;
    /**
     * The Tracker
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tracker;
    /**
     * The Event
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Event;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The DateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateTime;
    /**
     * Constructor method for GeofenceEventLog
     * @uses GeofenceEventLog::setId()
     * @uses GeofenceEventLog::setGeoId()
     * @uses GeofenceEventLog::setTracker()
     * @uses GeofenceEventLog::setEvent()
     * @uses GeofenceEventLog::setDescription()
     * @uses GeofenceEventLog::setDateTime()
     * @param int $id
     * @param int $geoId
     * @param string $tracker
     * @param string $event
     * @param string $description
     * @param string $dateTime
     */
    public function __construct($id = null, $geoId = null, $tracker = null, $event = null, $description = null, $dateTime = null)
    {
        $this
            ->setId($id)
            ->setGeoId($geoId)
            ->setTracker($tracker)
            ->setEvent($event)
            ->setDescription($description)
            ->setDateTime($dateTime);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\GeofenceEventLog
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get GeoId value
     * @return int
     */
    public function getGeoId()
    {
        return $this->GeoId;
    }
    /**
     * Set GeoId value
     * @param int $geoId
     * @return \StructType\GeofenceEventLog
     */
    public function setGeoId($geoId = null)
    {
        // validation for constraint: int
        if (!is_null($geoId) && !(is_int($geoId) || ctype_digit($geoId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($geoId, true), gettype($geoId)), __LINE__);
        }
        $this->GeoId = $geoId;
        return $this;
    }
    /**
     * Get Tracker value
     * @return string|null
     */
    public function getTracker()
    {
        return $this->Tracker;
    }
    /**
     * Set Tracker value
     * @param string $tracker
     * @return \StructType\GeofenceEventLog
     */
    public function setTracker($tracker = null)
    {
        // validation for constraint: string
        if (!is_null($tracker) && !is_string($tracker)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tracker, true), gettype($tracker)), __LINE__);
        }
        $this->Tracker = $tracker;
        return $this;
    }
    /**
     * Get Event value
     * @return string|null
     */
    public function getEvent()
    {
        return $this->Event;
    }
    /**
     * Set Event value
     * @param string $event
     * @return \StructType\GeofenceEventLog
     */
    public function setEvent($event = null)
    {
        // validation for constraint: string
        if (!is_null($event) && !is_string($event)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($event, true), gettype($event)), __LINE__);
        }
        $this->Event = $event;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\GeofenceEventLog
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get DateTime value
     * @return string|null
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \StructType\GeofenceEventLog
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
}
