<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventItinery StructType
 * @subpackage Structs
 */
class EventItinery extends AbstractStructBase
{
    /**
     * The ItId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItId;
    /**
     * The ItZoneId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItZoneId;
    /**
     * The ItLogId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItLogId;
    /**
     * The ItName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItName;
    /**
     * Constructor method for EventItinery
     * @uses EventItinery::setItId()
     * @uses EventItinery::setItZoneId()
     * @uses EventItinery::setItLogId()
     * @uses EventItinery::setItName()
     * @param int $itId
     * @param int $itZoneId
     * @param int $itLogId
     * @param string $itName
     */
    public function __construct($itId = null, $itZoneId = null, $itLogId = null, $itName = null)
    {
        $this
            ->setItId($itId)
            ->setItZoneId($itZoneId)
            ->setItLogId($itLogId)
            ->setItName($itName);
    }
    /**
     * Get ItId value
     * @return int
     */
    public function getItId()
    {
        return $this->ItId;
    }
    /**
     * Set ItId value
     * @param int $itId
     * @return \StructType\EventItinery
     */
    public function setItId($itId = null)
    {
        // validation for constraint: int
        if (!is_null($itId) && !(is_int($itId) || ctype_digit($itId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itId, true), gettype($itId)), __LINE__);
        }
        $this->ItId = $itId;
        return $this;
    }
    /**
     * Get ItZoneId value
     * @return int
     */
    public function getItZoneId()
    {
        return $this->ItZoneId;
    }
    /**
     * Set ItZoneId value
     * @param int $itZoneId
     * @return \StructType\EventItinery
     */
    public function setItZoneId($itZoneId = null)
    {
        // validation for constraint: int
        if (!is_null($itZoneId) && !(is_int($itZoneId) || ctype_digit($itZoneId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itZoneId, true), gettype($itZoneId)), __LINE__);
        }
        $this->ItZoneId = $itZoneId;
        return $this;
    }
    /**
     * Get ItLogId value
     * @return int
     */
    public function getItLogId()
    {
        return $this->ItLogId;
    }
    /**
     * Set ItLogId value
     * @param int $itLogId
     * @return \StructType\EventItinery
     */
    public function setItLogId($itLogId = null)
    {
        // validation for constraint: int
        if (!is_null($itLogId) && !(is_int($itLogId) || ctype_digit($itLogId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itLogId, true), gettype($itLogId)), __LINE__);
        }
        $this->ItLogId = $itLogId;
        return $this;
    }
    /**
     * Get ItName value
     * @return string|null
     */
    public function getItName()
    {
        return $this->ItName;
    }
    /**
     * Set ItName value
     * @param string $itName
     * @return \StructType\EventItinery
     */
    public function setItName($itName = null)
    {
        // validation for constraint: string
        if (!is_null($itName) && !is_string($itName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itName, true), gettype($itName)), __LINE__);
        }
        $this->ItName = $itName;
        return $this;
    }
}
