<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeofenceBasicInformation StructType
 * @subpackage Structs
 */
class GeofenceBasicInformation extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The Group
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Group;
    /**
     * The Index
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Index;
    /**
     * The Tracker
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tracker;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for GeofenceBasicInformation
     * @uses GeofenceBasicInformation::setId()
     * @uses GeofenceBasicInformation::setGroup()
     * @uses GeofenceBasicInformation::setIndex()
     * @uses GeofenceBasicInformation::setTracker()
     * @uses GeofenceBasicInformation::setName()
     * @param int $id
     * @param int $group
     * @param int $index
     * @param string $tracker
     * @param string $name
     */
    public function __construct($id = null, $group = null, $index = null, $tracker = null, $name = null)
    {
        $this
            ->setId($id)
            ->setGroup($group)
            ->setIndex($index)
            ->setTracker($tracker)
            ->setName($name);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\GeofenceBasicInformation
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Group value
     * @return int
     */
    public function getGroup()
    {
        return $this->Group;
    }
    /**
     * Set Group value
     * @param int $group
     * @return \StructType\GeofenceBasicInformation
     */
    public function setGroup($group = null)
    {
        // validation for constraint: int
        if (!is_null($group) && !(is_int($group) || ctype_digit($group))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($group, true), gettype($group)), __LINE__);
        }
        $this->Group = $group;
        return $this;
    }
    /**
     * Get Index value
     * @return int
     */
    public function getIndex()
    {
        return $this->Index;
    }
    /**
     * Set Index value
     * @param int $index
     * @return \StructType\GeofenceBasicInformation
     */
    public function setIndex($index = null)
    {
        // validation for constraint: int
        if (!is_null($index) && !(is_int($index) || ctype_digit($index))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($index, true), gettype($index)), __LINE__);
        }
        $this->Index = $index;
        return $this;
    }
    /**
     * Get Tracker value
     * @return string|null
     */
    public function getTracker()
    {
        return $this->Tracker;
    }
    /**
     * Set Tracker value
     * @param string $tracker
     * @return \StructType\GeofenceBasicInformation
     */
    public function setTracker($tracker = null)
    {
        // validation for constraint: string
        if (!is_null($tracker) && !is_string($tracker)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tracker, true), gettype($tracker)), __LINE__);
        }
        $this->Tracker = $tracker;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\GeofenceBasicInformation
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
}
