<?php

namespace EnumType;

/**
 * This class stands for SellingManagerPaisaPayPropertyTypeCodeType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Container for the PaisaPay alert types.
 * @subpackage Enumerations
 */
class SellingManagerPaisaPayPropertyTypeCodeType
{
    /**
     * Constant for value 'PaisaPayAwaitingShipment'
     * Meta informations extracted from the WSDL
     * - documentation: PaisaPay items awaiting shipment.
     * @return string 'PaisaPayAwaitingShipment'
     */
    const VALUE_PAISA_PAY_AWAITING_SHIPMENT = 'PaisaPayAwaitingShipment';
    /**
     * Constant for value 'PaisaPayTimeExtensionRequestDeclined'
     * Meta informations extracted from the WSDL
     * - documentation: PaisaPay items for which time extension requests are rejected by the buyers.
     * @return string 'PaisaPayTimeExtensionRequestDeclined'
     */
    const VALUE_PAISA_PAY_TIME_EXTENSION_REQUEST_DECLINED = 'PaisaPayTimeExtensionRequestDeclined';
    /**
     * Constant for value 'PaisaPayPendingReceived'
     * Meta informations extracted from the WSDL
     * - documentation: PaisaPay items for which the item receipt has not yet been confirmed by the buyer or not yet been auto-confirmed by the system.
     * @return string 'PaisaPayPendingReceived'
     */
    const VALUE_PAISA_PAY_PENDING_RECEIVED = 'PaisaPayPendingReceived';
    /**
     * Constant for value 'PaisaPayRefundInitiated'
     * Meta informations extracted from the WSDL
     * - documentation: PaisaPay items for which buyers have filed "Item not received".
     * @return string 'PaisaPayRefundInitiated'
     */
    const VALUE_PAISA_PAY_REFUND_INITIATED = 'PaisaPayRefundInitiated';
    /**
     * Constant for value 'PaisaPayTimeExtensionRequested'
     * Meta informations extracted from the WSDL
     * - documentation: PaisaPay items for which the seller has requested a time extension to enter the shipping information.
     * @return string 'PaisaPayTimeExtensionRequested'
     */
    const VALUE_PAISA_PAY_TIME_EXTENSION_REQUESTED = 'PaisaPayTimeExtensionRequested';
    /**
     * Constant for value 'CustomCode'
     * Meta informations extracted from the WSDL
     * - documentation: (out) Reserved for internal or future use.
     * @return string 'CustomCode'
     */
    const VALUE_CUSTOM_CODE = 'CustomCode';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PAISA_PAY_AWAITING_SHIPMENT
     * @uses self::VALUE_PAISA_PAY_TIME_EXTENSION_REQUEST_DECLINED
     * @uses self::VALUE_PAISA_PAY_PENDING_RECEIVED
     * @uses self::VALUE_PAISA_PAY_REFUND_INITIATED
     * @uses self::VALUE_PAISA_PAY_TIME_EXTENSION_REQUESTED
     * @uses self::VALUE_CUSTOM_CODE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PAISA_PAY_AWAITING_SHIPMENT,
            self::VALUE_PAISA_PAY_TIME_EXTENSION_REQUEST_DECLINED,
            self::VALUE_PAISA_PAY_PENDING_RECEIVED,
            self::VALUE_PAISA_PAY_REFUND_INITIATED,
            self::VALUE_PAISA_PAY_TIME_EXTENSION_REQUESTED,
            self::VALUE_CUSTOM_CODE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
