<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MaximumBuyerPolicyViolationsDetailsType StructType
 * Meta informations extracted from the WSDL
 * - documentation: The maximum number of policy violations and the durations that can be designated by sellers at this site. This is applicable only to sellers.
 * @subpackage Structs
 */
class MaximumBuyerPolicyViolationsDetailsType extends AbstractStructBase
{
    /**
     * The NumberOfPolicyViolations
     * Meta informations extracted from the WSDL
     * - documentation: The number of policy violation that can be used to limit buyers at the site. This is applicable only to sellers.
     * - minOccurs: 0
     * @var \StructType\NumberOfPolicyViolationsDetailsType
     */
    public $NumberOfPolicyViolations;
    /**
     * The PolicyViolationDuration
     * Meta informations extracted from the WSDL
     * - documentation: The policy violation duration(s) supported by the site. This is applicable only to sellers.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PolicyViolationDurationDetailsType[]
     */
    public $PolicyViolationDuration;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for MaximumBuyerPolicyViolationsDetailsType
     * @uses MaximumBuyerPolicyViolationsDetailsType::setNumberOfPolicyViolations()
     * @uses MaximumBuyerPolicyViolationsDetailsType::setPolicyViolationDuration()
     * @uses MaximumBuyerPolicyViolationsDetailsType::setAny()
     * @param \StructType\NumberOfPolicyViolationsDetailsType $numberOfPolicyViolations
     * @param \StructType\PolicyViolationDurationDetailsType[] $policyViolationDuration
     * @param \DOMDocument $any
     */
    public function __construct(\StructType\NumberOfPolicyViolationsDetailsType $numberOfPolicyViolations = null, array $policyViolationDuration = array(), \DOMDocument $any = null)
    {
        $this
            ->setNumberOfPolicyViolations($numberOfPolicyViolations)
            ->setPolicyViolationDuration($policyViolationDuration)
            ->setAny($any);
    }
    /**
     * Get NumberOfPolicyViolations value
     * @return \StructType\NumberOfPolicyViolationsDetailsType|null
     */
    public function getNumberOfPolicyViolations()
    {
        return $this->NumberOfPolicyViolations;
    }
    /**
     * Set NumberOfPolicyViolations value
     * @param \StructType\NumberOfPolicyViolationsDetailsType $numberOfPolicyViolations
     * @return \StructType\MaximumBuyerPolicyViolationsDetailsType
     */
    public function setNumberOfPolicyViolations(\StructType\NumberOfPolicyViolationsDetailsType $numberOfPolicyViolations = null)
    {
        $this->NumberOfPolicyViolations = $numberOfPolicyViolations;
        return $this;
    }
    /**
     * Get PolicyViolationDuration value
     * @return \StructType\PolicyViolationDurationDetailsType[]|null
     */
    public function getPolicyViolationDuration()
    {
        return $this->PolicyViolationDuration;
    }
    /**
     * This method is responsible for validating the values passed to the setPolicyViolationDuration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPolicyViolationDuration method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePolicyViolationDurationForArrayConstraintsFromSetPolicyViolationDuration(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $maximumBuyerPolicyViolationsDetailsTypePolicyViolationDurationItem) {
            // validation for constraint: itemType
            if (!$maximumBuyerPolicyViolationsDetailsTypePolicyViolationDurationItem instanceof \StructType\PolicyViolationDurationDetailsType) {
                $invalidValues[] = is_object($maximumBuyerPolicyViolationsDetailsTypePolicyViolationDurationItem) ? get_class($maximumBuyerPolicyViolationsDetailsTypePolicyViolationDurationItem) : sprintf('%s(%s)', gettype($maximumBuyerPolicyViolationsDetailsTypePolicyViolationDurationItem), var_export($maximumBuyerPolicyViolationsDetailsTypePolicyViolationDurationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PolicyViolationDuration property can only contain items of type \StructType\PolicyViolationDurationDetailsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PolicyViolationDuration value
     * @throws \InvalidArgumentException
     * @param \StructType\PolicyViolationDurationDetailsType[] $policyViolationDuration
     * @return \StructType\MaximumBuyerPolicyViolationsDetailsType
     */
    public function setPolicyViolationDuration(array $policyViolationDuration = array())
    {
        // validation for constraint: array
        if ('' !== ($policyViolationDurationArrayErrorMessage = self::validatePolicyViolationDurationForArrayConstraintsFromSetPolicyViolationDuration($policyViolationDuration))) {
            throw new \InvalidArgumentException($policyViolationDurationArrayErrorMessage, __LINE__);
        }
        $this->PolicyViolationDuration = $policyViolationDuration;
        return $this;
    }
    /**
     * Add item to PolicyViolationDuration value
     * @throws \InvalidArgumentException
     * @param \StructType\PolicyViolationDurationDetailsType $item
     * @return \StructType\MaximumBuyerPolicyViolationsDetailsType
     */
    public function addToPolicyViolationDuration(\StructType\PolicyViolationDurationDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PolicyViolationDurationDetailsType) {
            throw new \InvalidArgumentException(sprintf('The PolicyViolationDuration property can only contain items of type \StructType\PolicyViolationDurationDetailsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PolicyViolationDuration[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\MaximumBuyerPolicyViolationsDetailsType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MaximumBuyerPolicyViolationsDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
