<?php

namespace EnumType;

/**
 * This class stands for StoreSubscriptionLevelCodeType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: User's eBay Store subscription level.
 * @subpackage Enumerations
 */
class StoreSubscriptionLevelCodeType
{
    /**
     * Constant for value 'Close'
     * Meta informations extracted from the WSDL
     * - documentation: This closes your eBay Store and cancels your eBay Store subscription. All of your current Online Auction and Fixed Price items will remain active until their ending date is reached or they are sold. All your Store pictures hosted on
     * eBay will be deleted unless you have a Picture Manager subscription.
     * @return string 'Close'
     */
    const VALUE_CLOSE = 'Close';
    /**
     * Constant for value 'Basic'
     * Meta informations extracted from the WSDL
     * - documentation: Basic level subscription.
     * @return string 'Basic'
     */
    const VALUE_BASIC = 'Basic';
    /**
     * Constant for value 'Featured'
     * Meta informations extracted from the WSDL
     * - documentation: Featured level subscription.
     * @return string 'Featured'
     */
    const VALUE_FEATURED = 'Featured';
    /**
     * Constant for value 'Anchor'
     * Meta informations extracted from the WSDL
     * - documentation: Anchor level subscription.
     * @return string 'Anchor'
     */
    const VALUE_ANCHOR = 'Anchor';
    /**
     * Constant for value 'CustomCode'
     * Meta informations extracted from the WSDL
     * - documentation: Reserved for internal or future use.
     * @return string 'CustomCode'
     */
    const VALUE_CUSTOM_CODE = 'CustomCode';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CLOSE
     * @uses self::VALUE_BASIC
     * @uses self::VALUE_FEATURED
     * @uses self::VALUE_ANCHOR
     * @uses self::VALUE_CUSTOM_CODE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CLOSE,
            self::VALUE_BASIC,
            self::VALUE_FEATURED,
            self::VALUE_ANCHOR,
            self::VALUE_CUSTOM_CODE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
