<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxDetailsType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type defining the TaxDetails container, which consists of detailed sales tax information for an order line item, including the tax type and description, sales tax on the item cost, and sales tax related to shipping and handling. The
 * information in this container supercedes/overrides the sales tax information in the ShippingDetails.SalesTax container.
 * @subpackage Structs
 */
class TaxDetailsType extends AbstractStructBase
{
    /**
     * The Imposition
     * Meta informations extracted from the WSDL
     * - documentation: This field indicates the sales tax type. A separate TaxDetails container is required for each unique imposition (tax type).
     * - minOccurs: 0
     * @var string
     */
    public $Imposition;
    /**
     * The TaxDescription
     * Meta informations extracted from the WSDL
     * - documentation: This field indicates the description of the sales tax.
     * - minOccurs: 0
     * @var string
     */
    public $TaxDescription;
    /**
     * The TaxAmount
     * Meta informations extracted from the WSDL
     * - documentation: This value is the total amount of sales tax for the order line item for the corresponding impositiion (tax type). <br><br> <b>TaxAmount</b> = <b>TaxOnSubtotalAmount</b> + <b>TaxOnShippingAmount</b> + <b>TaxOnHandlingAmount</b>
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $TaxAmount;
    /**
     * The TaxOnSubtotalAmount
     * Meta informations extracted from the WSDL
     * - documentation: This value is the amount of sales tax applied based on the unit cost of the order line item for the corresponding impositiion (tax type).
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $TaxOnSubtotalAmount;
    /**
     * The TaxOnShippingAmount
     * Meta informations extracted from the WSDL
     * - documentation: This value is the amount of sales tax applied based on shipping costs for the order line item for the corresponding impositiion (tax type).
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $TaxOnShippingAmount;
    /**
     * The TaxOnHandlingAmount
     * Meta informations extracted from the WSDL
     * - documentation: This value is the amount of sales tax applied based on handling costs for the order line item for the corresponding impositiion (tax type).
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $TaxOnHandlingAmount;
    /**
     * The TaxCode
     * Meta informations extracted from the WSDL
     * - documentation: This value is the actual tax ID for the buyer. This field will generally only be returned if a seller on the Italy or Spain sites required that the buyer supply a tax ID during the checkout process. If the
     * <b>Order.BuyerTaxIdentifier</b> container is returned, the type of tax ID can be found in the <b>BuyerTaxIdentifier.Type</b> field.
     * - minOccurs: 0
     * @var string
     */
    public $TaxCode;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for TaxDetailsType
     * @uses TaxDetailsType::setImposition()
     * @uses TaxDetailsType::setTaxDescription()
     * @uses TaxDetailsType::setTaxAmount()
     * @uses TaxDetailsType::setTaxOnSubtotalAmount()
     * @uses TaxDetailsType::setTaxOnShippingAmount()
     * @uses TaxDetailsType::setTaxOnHandlingAmount()
     * @uses TaxDetailsType::setTaxCode()
     * @uses TaxDetailsType::setAny()
     * @param string $imposition
     * @param string $taxDescription
     * @param \StructType\AmountType $taxAmount
     * @param \StructType\AmountType $taxOnSubtotalAmount
     * @param \StructType\AmountType $taxOnShippingAmount
     * @param \StructType\AmountType $taxOnHandlingAmount
     * @param string $taxCode
     * @param \DOMDocument $any
     */
    public function __construct($imposition = null, $taxDescription = null, \StructType\AmountType $taxAmount = null, \StructType\AmountType $taxOnSubtotalAmount = null, \StructType\AmountType $taxOnShippingAmount = null, \StructType\AmountType $taxOnHandlingAmount = null, $taxCode = null, \DOMDocument $any = null)
    {
        $this
            ->setImposition($imposition)
            ->setTaxDescription($taxDescription)
            ->setTaxAmount($taxAmount)
            ->setTaxOnSubtotalAmount($taxOnSubtotalAmount)
            ->setTaxOnShippingAmount($taxOnShippingAmount)
            ->setTaxOnHandlingAmount($taxOnHandlingAmount)
            ->setTaxCode($taxCode)
            ->setAny($any);
    }
    /**
     * Get Imposition value
     * @return string|null
     */
    public function getImposition()
    {
        return $this->Imposition;
    }
    /**
     * Set Imposition value
     * @uses \EnumType\TaxTypeCodeType::valueIsValid()
     * @uses \EnumType\TaxTypeCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $imposition
     * @return \StructType\TaxDetailsType
     */
    public function setImposition($imposition = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TaxTypeCodeType::valueIsValid($imposition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TaxTypeCodeType', is_array($imposition) ? implode(', ', $imposition) : var_export($imposition, true), implode(', ', \EnumType\TaxTypeCodeType::getValidValues())), __LINE__);
        }
        $this->Imposition = $imposition;
        return $this;
    }
    /**
     * Get TaxDescription value
     * @return string|null
     */
    public function getTaxDescription()
    {
        return $this->TaxDescription;
    }
    /**
     * Set TaxDescription value
     * @uses \EnumType\TaxDescriptionCodeType::valueIsValid()
     * @uses \EnumType\TaxDescriptionCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taxDescription
     * @return \StructType\TaxDetailsType
     */
    public function setTaxDescription($taxDescription = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TaxDescriptionCodeType::valueIsValid($taxDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TaxDescriptionCodeType', is_array($taxDescription) ? implode(', ', $taxDescription) : var_export($taxDescription, true), implode(', ', \EnumType\TaxDescriptionCodeType::getValidValues())), __LINE__);
        }
        $this->TaxDescription = $taxDescription;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return \StructType\AmountType|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param \StructType\AmountType $taxAmount
     * @return \StructType\TaxDetailsType
     */
    public function setTaxAmount(\StructType\AmountType $taxAmount = null)
    {
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get TaxOnSubtotalAmount value
     * @return \StructType\AmountType|null
     */
    public function getTaxOnSubtotalAmount()
    {
        return $this->TaxOnSubtotalAmount;
    }
    /**
     * Set TaxOnSubtotalAmount value
     * @param \StructType\AmountType $taxOnSubtotalAmount
     * @return \StructType\TaxDetailsType
     */
    public function setTaxOnSubtotalAmount(\StructType\AmountType $taxOnSubtotalAmount = null)
    {
        $this->TaxOnSubtotalAmount = $taxOnSubtotalAmount;
        return $this;
    }
    /**
     * Get TaxOnShippingAmount value
     * @return \StructType\AmountType|null
     */
    public function getTaxOnShippingAmount()
    {
        return $this->TaxOnShippingAmount;
    }
    /**
     * Set TaxOnShippingAmount value
     * @param \StructType\AmountType $taxOnShippingAmount
     * @return \StructType\TaxDetailsType
     */
    public function setTaxOnShippingAmount(\StructType\AmountType $taxOnShippingAmount = null)
    {
        $this->TaxOnShippingAmount = $taxOnShippingAmount;
        return $this;
    }
    /**
     * Get TaxOnHandlingAmount value
     * @return \StructType\AmountType|null
     */
    public function getTaxOnHandlingAmount()
    {
        return $this->TaxOnHandlingAmount;
    }
    /**
     * Set TaxOnHandlingAmount value
     * @param \StructType\AmountType $taxOnHandlingAmount
     * @return \StructType\TaxDetailsType
     */
    public function setTaxOnHandlingAmount(\StructType\AmountType $taxOnHandlingAmount = null)
    {
        $this->TaxOnHandlingAmount = $taxOnHandlingAmount;
        return $this;
    }
    /**
     * Get TaxCode value
     * @return string|null
     */
    public function getTaxCode()
    {
        return $this->TaxCode;
    }
    /**
     * Set TaxCode value
     * @param string $taxCode
     * @return \StructType\TaxDetailsType
     */
    public function setTaxCode($taxCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxCode) && !is_string($taxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCode, true), gettype($taxCode)), __LINE__);
        }
        $this->TaxCode = $taxCode;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\TaxDetailsType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TaxDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
