<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductIdentifiersType StructType
 * Meta informations extracted from the WSDL
 * - documentation: This type is used to provide details about recommended Product Identifier types. The <b>ProductIdentifiers</b> container will consist of one or more Product Identifier types that can be, or possibly required to be used when listing a
 * product. <br> <br> <span class="tablenote"><b>Note:</b> The <b>ProductIdentifiers</b> container will only be returned in the Sandbox environment for the time being. This container has not been wired on in production. An alternative way to see if a
 * Product Identifier type is required for a category is to use the <b>GetCategoryFeatures</b> call and look for the values returned under the <b>EANEnabled</b>, <b>ISBNEnabled</b>, <b>UPCEnabled</b>, and other fields that indicate the Product
 * Identifier types that are supported/required for the category.<br> <br>
 * @subpackage Structs
 */
class ProductIdentifiersType extends AbstractStructBase
{
    /**
     * The ValidationRules
     * Meta informations extracted from the WSDL
     * - documentation: This container holds the <b>MinRequired</b> field, whose value will indicate whether or not one or more Product Identifier types (returned in a corresponding <b>NameRecommendation</b> container) are required when listing a product.
     * If two Product Identifier types are returned, and the <b>MinRequired</b> value is the <code>2</code>, the seller will be required to use both Product Identifier types at listing time. If the <b>MinRequired</b> value was <code>0</code>, one or both of
     * those Product Identifier types could be used, but they would not be required.
     * @var \StructType\GroupValidationRulesType
     */
    public $ValidationRules;
    /**
     * The NameRecommendation
     * Meta informations extracted from the WSDL
     * - documentation: A separate <b>NameRecommendation</b> container will be returned for each Product Identifier type that is supported/required by the category. These Product Identifier types will be common Global Trade Item Number (GTIN) types such as
     * UPC, ISBN, and EAN. To see if one or more of the Product Identifier types are actually required at listing time, the seller will need to look at the <b>ValidationRules</b> container and the <b>MinRequired</b> value. If two Product Identifier types
     * are returned, and the <b>MinRequired</b> value is the <code>2</code>, the seller will be required to use both Product Identifier types at listing time. If the <b>MinRequired</b> value was <code>0</code>, one or both of those Product Identifier types
     * could be used, but they would not be required.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NameRecommendationType[]
     */
    public $NameRecommendation;
    /**
     * Constructor method for ProductIdentifiersType
     * @uses ProductIdentifiersType::setValidationRules()
     * @uses ProductIdentifiersType::setNameRecommendation()
     * @param \StructType\GroupValidationRulesType $validationRules
     * @param \StructType\NameRecommendationType[] $nameRecommendation
     */
    public function __construct(\StructType\GroupValidationRulesType $validationRules = null, array $nameRecommendation = array())
    {
        $this
            ->setValidationRules($validationRules)
            ->setNameRecommendation($nameRecommendation);
    }
    /**
     * Get ValidationRules value
     * @return \StructType\GroupValidationRulesType|null
     */
    public function getValidationRules()
    {
        return $this->ValidationRules;
    }
    /**
     * Set ValidationRules value
     * @param \StructType\GroupValidationRulesType $validationRules
     * @return \StructType\ProductIdentifiersType
     */
    public function setValidationRules(\StructType\GroupValidationRulesType $validationRules = null)
    {
        $this->ValidationRules = $validationRules;
        return $this;
    }
    /**
     * Get NameRecommendation value
     * @return \StructType\NameRecommendationType[]|null
     */
    public function getNameRecommendation()
    {
        return $this->NameRecommendation;
    }
    /**
     * This method is responsible for validating the values passed to the setNameRecommendation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNameRecommendation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameRecommendationForArrayConstraintsFromSetNameRecommendation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productIdentifiersTypeNameRecommendationItem) {
            // validation for constraint: itemType
            if (!$productIdentifiersTypeNameRecommendationItem instanceof \StructType\NameRecommendationType) {
                $invalidValues[] = is_object($productIdentifiersTypeNameRecommendationItem) ? get_class($productIdentifiersTypeNameRecommendationItem) : sprintf('%s(%s)', gettype($productIdentifiersTypeNameRecommendationItem), var_export($productIdentifiersTypeNameRecommendationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NameRecommendation property can only contain items of type \StructType\NameRecommendationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NameRecommendation value
     * @throws \InvalidArgumentException
     * @param \StructType\NameRecommendationType[] $nameRecommendation
     * @return \StructType\ProductIdentifiersType
     */
    public function setNameRecommendation(array $nameRecommendation = array())
    {
        // validation for constraint: array
        if ('' !== ($nameRecommendationArrayErrorMessage = self::validateNameRecommendationForArrayConstraintsFromSetNameRecommendation($nameRecommendation))) {
            throw new \InvalidArgumentException($nameRecommendationArrayErrorMessage, __LINE__);
        }
        $this->NameRecommendation = $nameRecommendation;
        return $this;
    }
    /**
     * Add item to NameRecommendation value
     * @throws \InvalidArgumentException
     * @param \StructType\NameRecommendationType $item
     * @return \StructType\ProductIdentifiersType
     */
    public function addToNameRecommendation(\StructType\NameRecommendationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NameRecommendationType) {
            throw new \InvalidArgumentException(sprintf('The NameRecommendation property can only contain items of type \StructType\NameRecommendationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NameRecommendation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductIdentifiersType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
