<?php

namespace EnumType;

/**
 * This class stands for ShippingCarrierCodeType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Identifies a shipping carrier used to ship an order, and the countries served by that carrier. <br/><br/> <span class="tablenote"> <strong>Note:</strong> Commonly used shipping carriers can also be found by calling
 * <b>GeteBayDetails</b> with <b>DetailName</b> set to <b>ShippingCarrierDetails</b> and examining the returned <strong>ShippingCarrierDetails.ShippingCarrier</strong> field. </span>
 * @subpackage Enumerations
 */
class ShippingCarrierCodeType
{
    /**
     * Constant for value 'UPS'
     * @return string 'UPS'
     */
    const VALUE_UPS = 'UPS';
    /**
     * Constant for value 'USPS'
     * @return string 'USPS'
     */
    const VALUE_USPS = 'USPS';
    /**
     * Constant for value 'FedEx'
     * @return string 'FedEx'
     */
    const VALUE_FED_EX = 'FedEx';
    /**
     * Constant for value 'DeutschePost'
     * @return string 'DeutschePost'
     */
    const VALUE_DEUTSCHE_POST = 'DeutschePost';
    /**
     * Constant for value 'DHL'
     * @return string 'DHL'
     */
    const VALUE_DHL = 'DHL';
    /**
     * Constant for value 'Hermes'
     * @return string 'Hermes'
     */
    const VALUE_HERMES = 'Hermes';
    /**
     * Constant for value 'iLoxx'
     * @return string 'iLoxx'
     */
    const VALUE_I_LOXX = 'iLoxx';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Constant for value 'ColiposteDomestic'
     * @return string 'ColiposteDomestic'
     */
    const VALUE_COLIPOSTE_DOMESTIC = 'ColiposteDomestic';
    /**
     * Constant for value 'ColiposteInternational'
     * @return string 'ColiposteInternational'
     */
    const VALUE_COLIPOSTE_INTERNATIONAL = 'ColiposteInternational';
    /**
     * Constant for value 'Chronopost'
     * @return string 'Chronopost'
     */
    const VALUE_CHRONOPOST = 'Chronopost';
    /**
     * Constant for value 'Correos'
     * @return string 'Correos'
     */
    const VALUE_CORREOS = 'Correos';
    /**
     * Constant for value 'Seur'
     * @return string 'Seur'
     */
    const VALUE_SEUR = 'Seur';
    /**
     * Constant for value 'Nacex'
     * @return string 'Nacex'
     */
    const VALUE_NACEX = 'Nacex';
    /**
     * Constant for value 'FourPX'
     * @return string 'FourPX'
     */
    const VALUE_FOUR_PX = 'FourPX';
    /**
     * Constant for value 'FourPXCHINA'
     * @return string 'FourPXCHINA'
     */
    const VALUE_FOUR_PXCHINA = 'FourPXCHINA';
    /**
     * Constant for value 'FourPXExpress'
     * @return string 'FourPXExpress'
     */
    const VALUE_FOUR_PXEXPRESS = 'FourPXExpress';
    /**
     * Constant for value 'FourPXLTD'
     * @return string 'FourPXLTD'
     */
    const VALUE_FOUR_PXLTD = 'FourPXLTD';
    /**
     * Constant for value 'SevenLSP'
     * @return string 'SevenLSP'
     */
    const VALUE_SEVEN_LSP = 'SevenLSP';
    /**
     * Constant for value 'A1CourierServices'
     * @return string 'A1CourierServices'
     */
    const VALUE_A_1_COURIER_SERVICES = 'A1CourierServices';
    /**
     * Constant for value 'ABF'
     * @return string 'ABF'
     */
    const VALUE_ABF = 'ABF';
    /**
     * Constant for value 'AeroPost'
     * @return string 'AeroPost'
     */
    const VALUE_AERO_POST = 'AeroPost';
    /**
     * Constant for value 'ALLIEDEXPRESS'
     * @return string 'ALLIEDEXPRESS'
     */
    const VALUE_ALLIEDEXPRESS = 'ALLIEDEXPRESS';
    /**
     * Constant for value 'AMWST'
     * @return string 'AMWST'
     */
    const VALUE_AMWST = 'AMWST';
    /**
     * Constant for value 'AnPost'
     * @return string 'AnPost'
     */
    const VALUE_AN_POST = 'AnPost';
    /**
     * Constant for value 'APC'
     * @return string 'APC'
     */
    const VALUE_APC = 'APC';
    /**
     * Constant for value 'ARAMEX'
     * @return string 'ARAMEX'
     */
    const VALUE_ARAMEX = 'ARAMEX';
    /**
     * Constant for value 'ARVATO'
     * @return string 'ARVATO'
     */
    const VALUE_ARVATO = 'ARVATO';
    /**
     * Constant for value 'ASM'
     * @return string 'ASM'
     */
    const VALUE_ASM = 'ASM';
    /**
     * Constant for value 'AustraliaPost'
     * @return string 'AustraliaPost'
     */
    const VALUE_AUSTRALIA_POST = 'AustraliaPost';
    /**
     * Constant for value 'AustralianAirExpress'
     * @return string 'AustralianAirExpress'
     */
    const VALUE_AUSTRALIAN_AIR_EXPRESS = 'AustralianAirExpress';
    /**
     * Constant for value 'AVRT'
     * @return string 'AVRT'
     */
    const VALUE_AVRT = 'AVRT';
    /**
     * Constant for value 'BPost'
     * @return string 'BPost'
     */
    const VALUE_BPOST = 'BPost';
    /**
     * Constant for value 'Bartolini'
     * @return string 'Bartolini'
     */
    const VALUE_BARTOLINI = 'Bartolini';
    /**
     * Constant for value 'BELGIANPOST'
     * @return string 'BELGIANPOST'
     */
    const VALUE_BELGIANPOST = 'BELGIANPOST';
    /**
     * Constant for value 'BKNS'
     * @return string 'BKNS'
     */
    const VALUE_BKNS = 'BKNS';
    /**
     * Constant for value 'BluePackage'
     * @return string 'BluePackage'
     */
    const VALUE_BLUE_PACKAGE = 'BluePackage';
    /**
     * Constant for value 'BusinessPost'
     * @return string 'BusinessPost'
     */
    const VALUE_BUSINESS_POST = 'BusinessPost';
    /**
     * Constant for value 'CanPar'
     * @return string 'CanPar'
     */
    const VALUE_CAN_PAR = 'CanPar';
    /**
     * Constant for value 'CENF'
     * @return string 'CENF'
     */
    const VALUE_CENF = 'CENF';
    /**
     * Constant for value 'CEVA'
     * @return string 'CEVA'
     */
    const VALUE_CEVA = 'CEVA';
    /**
     * Constant for value 'ChinaPost'
     * @return string 'ChinaPost'
     */
    const VALUE_CHINA_POST = 'ChinaPost';
    /**
     * Constant for value 'Chronoexpres'
     * @return string 'Chronoexpres'
     */
    const VALUE_CHRONOEXPRES = 'Chronoexpres';
    /**
     * Constant for value 'CHUKOU1'
     * @return string 'CHUKOU1'
     */
    const VALUE_CHUKOU_1 = 'CHUKOU1';
    /**
     * Constant for value 'ChunghwaPost'
     * @return string 'ChunghwaPost'
     */
    const VALUE_CHUNGHWA_POST = 'ChunghwaPost';
    /**
     * Constant for value 'CitiPost'
     * @return string 'CitiPost'
     */
    const VALUE_CITI_POST = 'CitiPost';
    /**
     * Constant for value 'CityLink'
     * @return string 'CityLink'
     */
    const VALUE_CITY_LINK = 'CityLink';
    /**
     * Constant for value 'ClickandQuick'
     * @return string 'ClickandQuick'
     */
    const VALUE_CLICKAND_QUICK = 'ClickandQuick';
    /**
     * Constant for value 'CNWY'
     * @return string 'CNWY'
     */
    const VALUE_CNWY = 'CNWY';
    /**
     * Constant for value 'Colissimo'
     * @return string 'Colissimo'
     */
    const VALUE_COLISSIMO = 'Colissimo';
    /**
     * Constant for value 'CollectPlus'
     * @return string 'CollectPlus'
     */
    const VALUE_COLLECT_PLUS = 'CollectPlus';
    /**
     * Constant for value 'CPC'
     * @return string 'CPC'
     */
    const VALUE_CPC = 'CPC';
    /**
     * Constant for value 'DAIPost'
     * @return string 'DAIPost'
     */
    const VALUE_DAIPOST = 'DAIPost';
    /**
     * Constant for value 'DayandRoss'
     * @return string 'DayandRoss'
     */
    const VALUE_DAYAND_ROSS = 'DayandRoss';
    /**
     * Constant for value 'DBSchenker'
     * @return string 'DBSchenker'
     */
    const VALUE_DBSCHENKER = 'DBSchenker';
    /**
     * Constant for value 'DHLEXPRESS'
     * @return string 'DHLEXPRESS'
     */
    const VALUE_DHLEXPRESS = 'DHLEXPRESS';
    /**
     * Constant for value 'DHLGlobalMail'
     * @return string 'DHLGlobalMail'
     */
    const VALUE_DHLGLOBAL_MAIL = 'DHLGlobalMail';
    /**
     * Constant for value 'DHLEKB'
     * @return string 'DHLEKB'
     */
    const VALUE_DHLEKB = 'DHLEKB';
    /**
     * Constant for value 'DHLG'
     * @return string 'DHLG'
     */
    const VALUE_DHLG = 'DHLG';
    /**
     * Constant for value 'DieSchweizerischePost'
     * @return string 'DieSchweizerischePost'
     */
    const VALUE_DIE_SCHWEIZERISCHE_POST = 'DieSchweizerischePost';
    /**
     * Constant for value 'DPD'
     * @return string 'DPD'
     */
    const VALUE_DPD = 'DPD';
    /**
     * Constant for value 'DPXThailand'
     * @return string 'DPXThailand'
     */
    const VALUE_DPXTHAILAND = 'DPXThailand';
    /**
     * Constant for value 'Ducros'
     * @return string 'Ducros'
     */
    const VALUE_DUCROS = 'Ducros';
    /**
     * Constant for value 'EGO'
     * @return string 'EGO'
     */
    const VALUE_EGO = 'EGO';
    /**
     * Constant for value 'EMF'
     * @return string 'EMF'
     */
    const VALUE_EMF = 'EMF';
    /**
     * Constant for value 'Exapaq'
     * @return string 'Exapaq'
     */
    const VALUE_EXAPAQ = 'Exapaq';
    /**
     * Constant for value 'Fastway'
     * @return string 'Fastway'
     */
    const VALUE_FASTWAY = 'Fastway';
    /**
     * Constant for value 'FASTWAYCOURIERS'
     * @return string 'FASTWAYCOURIERS'
     */
    const VALUE_FASTWAYCOURIERS = 'FASTWAYCOURIERS';
    /**
     * Constant for value 'FedExSmartPost'
     * @return string 'FedExSmartPost'
     */
    const VALUE_FED_EX_SMART_POST = 'FedExSmartPost';
    /**
     * Constant for value 'FLYT'
     * @return string 'FLYT'
     */
    const VALUE_FLYT = 'FLYT';
    /**
     * Constant for value 'FLYTExpress'
     * @return string 'FLYTExpress'
     */
    const VALUE_FLYTEXPRESS = 'FLYTExpress';
    /**
     * Constant for value 'FlytExpressUSDirectline'
     * @return string 'FlytExpressUSDirectline'
     */
    const VALUE_FLYT_EXPRESS_USDIRECTLINE = 'FlytExpressUSDirectline';
    /**
     * Constant for value 'FTFT'
     * @return string 'FTFT'
     */
    const VALUE_FTFT = 'FTFT';
    /**
     * Constant for value 'FulfilExpressAccStation'
     * @return string 'FulfilExpressAccStation'
     */
    const VALUE_FULFIL_EXPRESS_ACC_STATION = 'FulfilExpressAccStation';
    /**
     * Constant for value 'FulfilExpresseForCity'
     * @return string 'FulfilExpresseForCity'
     */
    const VALUE_FULFIL_EXPRESSE_FOR_CITY = 'FulfilExpresseForCity';
    /**
     * Constant for value 'FulfilExpressEverydaySource'
     * @return string 'FulfilExpressEverydaySource'
     */
    const VALUE_FULFIL_EXPRESS_EVERYDAY_SOURCE = 'FulfilExpressEverydaySource';
    /**
     * Constant for value 'FulfilExpressiTrimming'
     * @return string 'FulfilExpressiTrimming'
     */
    const VALUE_FULFIL_EXPRESSI_TRIMMING = 'FulfilExpressiTrimming';
    /**
     * Constant for value 'GLS'
     * @return string 'GLS'
     */
    const VALUE_GLS = 'GLS';
    /**
     * Constant for value 'HDUSA'
     * @return string 'HDUSA'
     */
    const VALUE_HDUSA = 'HDUSA';
    /**
     * Constant for value 'HomeDeliveryNetwork'
     * @return string 'HomeDeliveryNetwork'
     */
    const VALUE_HOME_DELIVERY_NETWORK = 'HomeDeliveryNetwork';
    /**
     * Constant for value 'HongKongPost'
     * @return string 'HongKongPost'
     */
    const VALUE_HONG_KONG_POST = 'HongKongPost';
    /**
     * Constant for value 'HUNTEREXPRESS'
     * @return string 'HUNTEREXPRESS'
     */
    const VALUE_HUNTEREXPRESS = 'HUNTEREXPRESS';
    /**
     * Constant for value 'IndiaPost'
     * @return string 'IndiaPost'
     */
    const VALUE_INDIA_POST = 'IndiaPost';
    /**
     * Constant for value 'IndonesiaPost'
     * @return string 'IndonesiaPost'
     */
    const VALUE_INDONESIA_POST = 'IndonesiaPost';
    /**
     * Constant for value 'Interlink'
     * @return string 'Interlink'
     */
    const VALUE_INTERLINK = 'Interlink';
    /**
     * Constant for value 'InterPost'
     * @return string 'InterPost'
     */
    const VALUE_INTER_POST = 'InterPost';
    /**
     * Constant for value 'IoInvio'
     * @return string 'IoInvio'
     */
    const VALUE_IO_INVIO = 'IoInvio';
    /**
     * Constant for value 'Iparcel'
     * @return string 'Iparcel'
     */
    const VALUE_IPARCEL = 'Iparcel';
    /**
     * Constant for value 'IsraelPost'
     * @return string 'IsraelPost'
     */
    const VALUE_ISRAEL_POST = 'IsraelPost';
    /**
     * Constant for value 'JapanPost'
     * @return string 'JapanPost'
     */
    const VALUE_JAPAN_POST = 'JapanPost';
    /**
     * Constant for value 'KIALA'
     * @return string 'KIALA'
     */
    const VALUE_KIALA = 'KIALA';
    /**
     * Constant for value 'KoreaPost'
     * @return string 'KoreaPost'
     */
    const VALUE_KOREA_POST = 'KoreaPost';
    /**
     * Constant for value 'LAPOSTE'
     * @return string 'LAPOSTE'
     */
    const VALUE_LAPOSTE = 'LAPOSTE';
    /**
     * Constant for value 'Landmark'
     * @return string 'Landmark'
     */
    const VALUE_LANDMARK = 'Landmark';
    /**
     * Constant for value 'LDSO'
     * @return string 'LDSO'
     */
    const VALUE_LDSO = 'LDSO';
    /**
     * Constant for value 'LTL'
     * @return string 'LTL'
     */
    const VALUE_LTL = 'LTL';
    /**
     * Constant for value 'MALAYSIAPOST'
     * @return string 'MALAYSIAPOST'
     */
    const VALUE_MALAYSIAPOST = 'MALAYSIAPOST';
    /**
     * Constant for value 'MannaFreight'
     * @return string 'MannaFreight'
     */
    const VALUE_MANNA_FREIGHT = 'MannaFreight';
    /**
     * Constant for value 'Metapack'
     * @return string 'Metapack'
     */
    const VALUE_METAPACK = 'Metapack';
    /**
     * Constant for value 'MNGTurkey'
     * @return string 'MNGTurkey'
     */
    const VALUE_MNGTURKEY = 'MNGTurkey';
    /**
     * Constant for value 'MondialRelay'
     * @return string 'MondialRelay'
     */
    const VALUE_MONDIAL_RELAY = 'MondialRelay';
    /**
     * Constant for value 'MRW'
     * @return string 'MRW'
     */
    const VALUE_MRW = 'MRW';
    /**
     * Constant for value 'MSI'
     * @return string 'MSI'
     */
    const VALUE_MSI = 'MSI';
    /**
     * Constant for value 'NEMF'
     * @return string 'NEMF'
     */
    const VALUE_NEMF = 'NEMF';
    /**
     * Constant for value 'ODFL'
     * @return string 'ODFL'
     */
    const VALUE_ODFL = 'ODFL';
    /**
     * Constant for value 'OFFD'
     * @return string 'OFFD'
     */
    const VALUE_OFFD = 'OFFD';
    /**
     * Constant for value 'ONTRACK'
     * @return string 'ONTRACK'
     */
    const VALUE_ONTRACK = 'ONTRACK';
    /**
     * Constant for value 'OsterreichischePostAG'
     * @return string 'OsterreichischePostAG'
     */
    const VALUE_OSTERREICHISCHE_POST_AG = 'OsterreichischePostAG';
    /**
     * Constant for value 'OVNT'
     * @return string 'OVNT'
     */
    const VALUE_OVNT = 'OVNT';
    /**
     * Constant for value 'ParcelPool'
     * @return string 'ParcelPool'
     */
    const VALUE_PARCEL_POOL = 'ParcelPool';
    /**
     * Constant for value 'Parcelforce'
     * @return string 'Parcelforce'
     */
    const VALUE_PARCELFORCE = 'Parcelforce';
    /**
     * Constant for value 'Philpost'
     * @return string 'Philpost'
     */
    const VALUE_PHILPOST = 'Philpost';
    /**
     * Constant for value 'Pilot'
     * @return string 'Pilot'
     */
    const VALUE_PILOT = 'Pilot';
    /**
     * Constant for value 'PITD'
     * @return string 'PITD'
     */
    const VALUE_PITD = 'PITD';
    /**
     * Constant for value 'PocztaPolska'
     * @return string 'PocztaPolska'
     */
    const VALUE_POCZTA_POLSKA = 'PocztaPolska';
    /**
     * Constant for value 'Pocztex'
     * @return string 'Pocztex'
     */
    const VALUE_POCZTEX = 'Pocztex';
    /**
     * Constant for value 'POSTITALIANO'
     * @return string 'POSTITALIANO'
     */
    const VALUE_POSTITALIANO = 'POSTITALIANO';
    /**
     * Constant for value 'PostNL'
     * @return string 'PostNL'
     */
    const VALUE_POST_NL = 'PostNL';
    /**
     * Constant for value 'PostNordNorway'
     * @return string 'PostNordNorway'
     */
    const VALUE_POST_NORD_NORWAY = 'PostNordNorway';
    /**
     * Constant for value 'PosteItaliane'
     * @return string 'PosteItaliane'
     */
    const VALUE_POSTE_ITALIANE = 'PosteItaliane';
    /**
     * Constant for value 'Prestige'
     * @return string 'Prestige'
     */
    const VALUE_PRESTIGE = 'Prestige';
    /**
     * Constant for value 'Quantium'
     * @return string 'Quantium'
     */
    const VALUE_QUANTIUM = 'Quantium';
    /**
     * Constant for value 'RETL'
     * @return string 'RETL'
     */
    const VALUE_RETL = 'RETL';
    /**
     * Constant for value 'RoyalMail'
     * @return string 'RoyalMail'
     */
    const VALUE_ROYAL_MAIL = 'RoyalMail';
    /**
     * Constant for value 'RRUN'
     * @return string 'RRUN'
     */
    const VALUE_RRUN = 'RRUN';
    /**
     * Constant for value 'SAIA'
     * @return string 'SAIA'
     */
    const VALUE_SAIA = 'SAIA';
    /**
     * Constant for value 'SDA'
     * @return string 'SDA'
     */
    const VALUE_SDA = 'SDA';
    /**
     * Constant for value 'SFC'
     * @return string 'SFC'
     */
    const VALUE_SFC = 'SFC';
    /**
     * Constant for value 'SFCExpress'
     * @return string 'SFCExpress'
     */
    const VALUE_SFCEXPRESS = 'SFCExpress';
    /**
     * Constant for value 'SINGAPOREPOST'
     * @return string 'SINGAPOREPOST'
     */
    const VALUE_SINGAPOREPOST = 'SINGAPOREPOST';
    /**
     * Constant for value 'Siodemka'
     * @return string 'Siodemka'
     */
    const VALUE_SIODEMKA = 'Siodemka';
    /**
     * Constant for value 'SioliandFontana'
     * @return string 'SioliandFontana'
     */
    const VALUE_SIOLIAND_FONTANA = 'SioliandFontana';
    /**
     * Constant for value 'SkynetMalaysia'
     * @return string 'SkynetMalaysia'
     */
    const VALUE_SKYNET_MALAYSIA = 'SkynetMalaysia';
    /**
     * Constant for value 'SMARTSEND'
     * @return string 'SMARTSEND'
     */
    const VALUE_SMARTSEND = 'SMARTSEND';
    /**
     * Constant for value 'Sogetras'
     * @return string 'Sogetras'
     */
    const VALUE_SOGETRAS = 'Sogetras';
    /**
     * Constant for value 'Spediamo'
     * @return string 'Spediamo'
     */
    const VALUE_SPEDIAMO = 'Spediamo';
    /**
     * Constant for value 'SpeeDee'
     * @return string 'SpeeDee'
     */
    const VALUE_SPEE_DEE = 'SpeeDee';
    /**
     * Constant for value 'StarTrack'
     * @return string 'StarTrack'
     */
    const VALUE_STAR_TRACK = 'StarTrack';
    /**
     * Constant for value 'SuntekExpressLTD'
     * @return string 'SuntekExpressLTD'
     */
    const VALUE_SUNTEK_EXPRESS_LTD = 'SuntekExpressLTD';
    /**
     * Constant for value 'SwissPost'
     * @return string 'SwissPost'
     */
    const VALUE_SWISS_POST = 'SwissPost';
    /**
     * Constant for value 'TELE'
     * @return string 'TELE'
     */
    const VALUE_TELE = 'TELE';
    /**
     * Constant for value 'TEMANDO'
     * @return string 'TEMANDO'
     */
    const VALUE_TEMANDO = 'TEMANDO';
    /**
     * Constant for value 'THAILANDPOST'
     * @return string 'THAILANDPOST'
     */
    const VALUE_THAILANDPOST = 'THAILANDPOST';
    /**
     * Constant for value 'TNT'
     * @return string 'TNT'
     */
    const VALUE_TNT = 'TNT';
    /**
     * Constant for value 'TNTEXPRESS'
     * @return string 'TNTEXPRESS'
     */
    const VALUE_TNTEXPRESS = 'TNTEXPRESS';
    /**
     * Constant for value 'TNTPost'
     * @return string 'TNTPost'
     */
    const VALUE_TNTPOST = 'TNTPost';
    /**
     * Constant for value 'Toll'
     * @return string 'Toll'
     */
    const VALUE_TOLL = 'Toll';
    /**
     * Constant for value 'TPG'
     * @return string 'TPG'
     */
    const VALUE_TPG = 'TPG';
    /**
     * Constant for value 'TWW'
     * @return string 'TWW'
     */
    const VALUE_TWW = 'TWW';
    /**
     * Constant for value 'UBI'
     * @return string 'UBI'
     */
    const VALUE_UBI = 'UBI';
    /**
     * Constant for value 'UKMail'
     * @return string 'UKMail'
     */
    const VALUE_UKMAIL = 'UKMail';
    /**
     * Constant for value 'UPSMailInnovations'
     * @return string 'UPSMailInnovations'
     */
    const VALUE_UPSMAIL_INNOVATIONS = 'UPSMailInnovations';
    /**
     * Constant for value 'UPSC'
     * @return string 'UPSC'
     */
    const VALUE_UPSC = 'UPSC';
    /**
     * Constant for value 'USFG'
     * @return string 'USFG'
     */
    const VALUE_USFG = 'USFG';
    /**
     * Constant for value 'USPSCeP'
     * @return string 'USPSCeP'
     */
    const VALUE_USPSCE_P = 'USPSCeP';
    /**
     * Constant for value 'USPSPMI'
     * @return string 'USPSPMI'
     */
    const VALUE_USPSPMI = 'USPSPMI';
    /**
     * Constant for value 'VietnamPost'
     * @return string 'VietnamPost'
     */
    const VALUE_VIETNAM_POST = 'VietnamPost';
    /**
     * Constant for value 'VITR'
     * @return string 'VITR'
     */
    const VALUE_VITR = 'VITR';
    /**
     * Constant for value 'WATKINS'
     * @return string 'WATKINS'
     */
    const VALUE_WATKINS = 'WATKINS';
    /**
     * Constant for value 'Winit'
     * @return string 'Winit'
     */
    const VALUE_WINIT = 'Winit';
    /**
     * Constant for value 'Wise'
     * @return string 'Wise'
     */
    const VALUE_WISE = 'Wise';
    /**
     * Constant for value 'WNdirect'
     * @return string 'WNdirect'
     */
    const VALUE_WNDIRECT = 'WNdirect';
    /**
     * Constant for value 'WPX'
     * @return string 'WPX'
     */
    const VALUE_WPX = 'WPX';
    /**
     * Constant for value 'YANWEN'
     * @return string 'YANWEN'
     */
    const VALUE_YANWEN = 'YANWEN';
    /**
     * Constant for value 'Yodel'
     * @return string 'Yodel'
     */
    const VALUE_YODEL = 'Yodel';
    /**
     * Constant for value 'YRC'
     * @return string 'YRC'
     */
    const VALUE_YRC = 'YRC';
    /**
     * Constant for value 'CustomCode'
     * @return string 'CustomCode'
     */
    const VALUE_CUSTOM_CODE = 'CustomCode';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UPS
     * @uses self::VALUE_USPS
     * @uses self::VALUE_FED_EX
     * @uses self::VALUE_DEUTSCHE_POST
     * @uses self::VALUE_DHL
     * @uses self::VALUE_HERMES
     * @uses self::VALUE_I_LOXX
     * @uses self::VALUE_OTHER
     * @uses self::VALUE_COLIPOSTE_DOMESTIC
     * @uses self::VALUE_COLIPOSTE_INTERNATIONAL
     * @uses self::VALUE_CHRONOPOST
     * @uses self::VALUE_CORREOS
     * @uses self::VALUE_SEUR
     * @uses self::VALUE_NACEX
     * @uses self::VALUE_FOUR_PX
     * @uses self::VALUE_FOUR_PXCHINA
     * @uses self::VALUE_FOUR_PXEXPRESS
     * @uses self::VALUE_FOUR_PXLTD
     * @uses self::VALUE_SEVEN_LSP
     * @uses self::VALUE_A_1_COURIER_SERVICES
     * @uses self::VALUE_ABF
     * @uses self::VALUE_AERO_POST
     * @uses self::VALUE_ALLIEDEXPRESS
     * @uses self::VALUE_AMWST
     * @uses self::VALUE_AN_POST
     * @uses self::VALUE_APC
     * @uses self::VALUE_ARAMEX
     * @uses self::VALUE_ARVATO
     * @uses self::VALUE_ASM
     * @uses self::VALUE_AUSTRALIA_POST
     * @uses self::VALUE_AUSTRALIAN_AIR_EXPRESS
     * @uses self::VALUE_AVRT
     * @uses self::VALUE_BPOST
     * @uses self::VALUE_BARTOLINI
     * @uses self::VALUE_BELGIANPOST
     * @uses self::VALUE_BKNS
     * @uses self::VALUE_BLUE_PACKAGE
     * @uses self::VALUE_BUSINESS_POST
     * @uses self::VALUE_CAN_PAR
     * @uses self::VALUE_CENF
     * @uses self::VALUE_CEVA
     * @uses self::VALUE_CHINA_POST
     * @uses self::VALUE_CHRONOEXPRES
     * @uses self::VALUE_CHUKOU_1
     * @uses self::VALUE_CHUNGHWA_POST
     * @uses self::VALUE_CITI_POST
     * @uses self::VALUE_CITY_LINK
     * @uses self::VALUE_CLICKAND_QUICK
     * @uses self::VALUE_CNWY
     * @uses self::VALUE_COLISSIMO
     * @uses self::VALUE_COLLECT_PLUS
     * @uses self::VALUE_CPC
     * @uses self::VALUE_DAIPOST
     * @uses self::VALUE_DAYAND_ROSS
     * @uses self::VALUE_DBSCHENKER
     * @uses self::VALUE_DHLEXPRESS
     * @uses self::VALUE_DHLGLOBAL_MAIL
     * @uses self::VALUE_DHLEKB
     * @uses self::VALUE_DHLG
     * @uses self::VALUE_DIE_SCHWEIZERISCHE_POST
     * @uses self::VALUE_DPD
     * @uses self::VALUE_DPXTHAILAND
     * @uses self::VALUE_DUCROS
     * @uses self::VALUE_EGO
     * @uses self::VALUE_EMF
     * @uses self::VALUE_EXAPAQ
     * @uses self::VALUE_FASTWAY
     * @uses self::VALUE_FASTWAYCOURIERS
     * @uses self::VALUE_FED_EX_SMART_POST
     * @uses self::VALUE_FLYT
     * @uses self::VALUE_FLYTEXPRESS
     * @uses self::VALUE_FLYT_EXPRESS_USDIRECTLINE
     * @uses self::VALUE_FTFT
     * @uses self::VALUE_FULFIL_EXPRESS_ACC_STATION
     * @uses self::VALUE_FULFIL_EXPRESSE_FOR_CITY
     * @uses self::VALUE_FULFIL_EXPRESS_EVERYDAY_SOURCE
     * @uses self::VALUE_FULFIL_EXPRESSI_TRIMMING
     * @uses self::VALUE_GLS
     * @uses self::VALUE_HDUSA
     * @uses self::VALUE_HOME_DELIVERY_NETWORK
     * @uses self::VALUE_HONG_KONG_POST
     * @uses self::VALUE_HUNTEREXPRESS
     * @uses self::VALUE_INDIA_POST
     * @uses self::VALUE_INDONESIA_POST
     * @uses self::VALUE_INTERLINK
     * @uses self::VALUE_INTER_POST
     * @uses self::VALUE_IO_INVIO
     * @uses self::VALUE_IPARCEL
     * @uses self::VALUE_ISRAEL_POST
     * @uses self::VALUE_JAPAN_POST
     * @uses self::VALUE_KIALA
     * @uses self::VALUE_KOREA_POST
     * @uses self::VALUE_LAPOSTE
     * @uses self::VALUE_LANDMARK
     * @uses self::VALUE_LDSO
     * @uses self::VALUE_LTL
     * @uses self::VALUE_MALAYSIAPOST
     * @uses self::VALUE_MANNA_FREIGHT
     * @uses self::VALUE_METAPACK
     * @uses self::VALUE_MNGTURKEY
     * @uses self::VALUE_MONDIAL_RELAY
     * @uses self::VALUE_MRW
     * @uses self::VALUE_MSI
     * @uses self::VALUE_NEMF
     * @uses self::VALUE_ODFL
     * @uses self::VALUE_OFFD
     * @uses self::VALUE_ONTRACK
     * @uses self::VALUE_OSTERREICHISCHE_POST_AG
     * @uses self::VALUE_OVNT
     * @uses self::VALUE_PARCEL_POOL
     * @uses self::VALUE_PARCELFORCE
     * @uses self::VALUE_PHILPOST
     * @uses self::VALUE_PILOT
     * @uses self::VALUE_PITD
     * @uses self::VALUE_POCZTA_POLSKA
     * @uses self::VALUE_POCZTEX
     * @uses self::VALUE_POSTITALIANO
     * @uses self::VALUE_POST_NL
     * @uses self::VALUE_POST_NORD_NORWAY
     * @uses self::VALUE_POSTE_ITALIANE
     * @uses self::VALUE_PRESTIGE
     * @uses self::VALUE_QUANTIUM
     * @uses self::VALUE_RETL
     * @uses self::VALUE_ROYAL_MAIL
     * @uses self::VALUE_RRUN
     * @uses self::VALUE_SAIA
     * @uses self::VALUE_SDA
     * @uses self::VALUE_SFC
     * @uses self::VALUE_SFCEXPRESS
     * @uses self::VALUE_SINGAPOREPOST
     * @uses self::VALUE_SIODEMKA
     * @uses self::VALUE_SIOLIAND_FONTANA
     * @uses self::VALUE_SKYNET_MALAYSIA
     * @uses self::VALUE_SMARTSEND
     * @uses self::VALUE_SOGETRAS
     * @uses self::VALUE_SPEDIAMO
     * @uses self::VALUE_SPEE_DEE
     * @uses self::VALUE_STAR_TRACK
     * @uses self::VALUE_SUNTEK_EXPRESS_LTD
     * @uses self::VALUE_SWISS_POST
     * @uses self::VALUE_TELE
     * @uses self::VALUE_TEMANDO
     * @uses self::VALUE_THAILANDPOST
     * @uses self::VALUE_TNT
     * @uses self::VALUE_TNTEXPRESS
     * @uses self::VALUE_TNTPOST
     * @uses self::VALUE_TOLL
     * @uses self::VALUE_TPG
     * @uses self::VALUE_TWW
     * @uses self::VALUE_UBI
     * @uses self::VALUE_UKMAIL
     * @uses self::VALUE_UPSMAIL_INNOVATIONS
     * @uses self::VALUE_UPSC
     * @uses self::VALUE_USFG
     * @uses self::VALUE_USPSCE_P
     * @uses self::VALUE_USPSPMI
     * @uses self::VALUE_VIETNAM_POST
     * @uses self::VALUE_VITR
     * @uses self::VALUE_WATKINS
     * @uses self::VALUE_WINIT
     * @uses self::VALUE_WISE
     * @uses self::VALUE_WNDIRECT
     * @uses self::VALUE_WPX
     * @uses self::VALUE_YANWEN
     * @uses self::VALUE_YODEL
     * @uses self::VALUE_YRC
     * @uses self::VALUE_CUSTOM_CODE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UPS,
            self::VALUE_USPS,
            self::VALUE_FED_EX,
            self::VALUE_DEUTSCHE_POST,
            self::VALUE_DHL,
            self::VALUE_HERMES,
            self::VALUE_I_LOXX,
            self::VALUE_OTHER,
            self::VALUE_COLIPOSTE_DOMESTIC,
            self::VALUE_COLIPOSTE_INTERNATIONAL,
            self::VALUE_CHRONOPOST,
            self::VALUE_CORREOS,
            self::VALUE_SEUR,
            self::VALUE_NACEX,
            self::VALUE_FOUR_PX,
            self::VALUE_FOUR_PXCHINA,
            self::VALUE_FOUR_PXEXPRESS,
            self::VALUE_FOUR_PXLTD,
            self::VALUE_SEVEN_LSP,
            self::VALUE_A_1_COURIER_SERVICES,
            self::VALUE_ABF,
            self::VALUE_AERO_POST,
            self::VALUE_ALLIEDEXPRESS,
            self::VALUE_AMWST,
            self::VALUE_AN_POST,
            self::VALUE_APC,
            self::VALUE_ARAMEX,
            self::VALUE_ARVATO,
            self::VALUE_ASM,
            self::VALUE_AUSTRALIA_POST,
            self::VALUE_AUSTRALIAN_AIR_EXPRESS,
            self::VALUE_AVRT,
            self::VALUE_BPOST,
            self::VALUE_BARTOLINI,
            self::VALUE_BELGIANPOST,
            self::VALUE_BKNS,
            self::VALUE_BLUE_PACKAGE,
            self::VALUE_BUSINESS_POST,
            self::VALUE_CAN_PAR,
            self::VALUE_CENF,
            self::VALUE_CEVA,
            self::VALUE_CHINA_POST,
            self::VALUE_CHRONOEXPRES,
            self::VALUE_CHUKOU_1,
            self::VALUE_CHUNGHWA_POST,
            self::VALUE_CITI_POST,
            self::VALUE_CITY_LINK,
            self::VALUE_CLICKAND_QUICK,
            self::VALUE_CNWY,
            self::VALUE_COLISSIMO,
            self::VALUE_COLLECT_PLUS,
            self::VALUE_CPC,
            self::VALUE_DAIPOST,
            self::VALUE_DAYAND_ROSS,
            self::VALUE_DBSCHENKER,
            self::VALUE_DHLEXPRESS,
            self::VALUE_DHLGLOBAL_MAIL,
            self::VALUE_DHLEKB,
            self::VALUE_DHLG,
            self::VALUE_DIE_SCHWEIZERISCHE_POST,
            self::VALUE_DPD,
            self::VALUE_DPXTHAILAND,
            self::VALUE_DUCROS,
            self::VALUE_EGO,
            self::VALUE_EMF,
            self::VALUE_EXAPAQ,
            self::VALUE_FASTWAY,
            self::VALUE_FASTWAYCOURIERS,
            self::VALUE_FED_EX_SMART_POST,
            self::VALUE_FLYT,
            self::VALUE_FLYTEXPRESS,
            self::VALUE_FLYT_EXPRESS_USDIRECTLINE,
            self::VALUE_FTFT,
            self::VALUE_FULFIL_EXPRESS_ACC_STATION,
            self::VALUE_FULFIL_EXPRESSE_FOR_CITY,
            self::VALUE_FULFIL_EXPRESS_EVERYDAY_SOURCE,
            self::VALUE_FULFIL_EXPRESSI_TRIMMING,
            self::VALUE_GLS,
            self::VALUE_HDUSA,
            self::VALUE_HOME_DELIVERY_NETWORK,
            self::VALUE_HONG_KONG_POST,
            self::VALUE_HUNTEREXPRESS,
            self::VALUE_INDIA_POST,
            self::VALUE_INDONESIA_POST,
            self::VALUE_INTERLINK,
            self::VALUE_INTER_POST,
            self::VALUE_IO_INVIO,
            self::VALUE_IPARCEL,
            self::VALUE_ISRAEL_POST,
            self::VALUE_JAPAN_POST,
            self::VALUE_KIALA,
            self::VALUE_KOREA_POST,
            self::VALUE_LAPOSTE,
            self::VALUE_LANDMARK,
            self::VALUE_LDSO,
            self::VALUE_LTL,
            self::VALUE_MALAYSIAPOST,
            self::VALUE_MANNA_FREIGHT,
            self::VALUE_METAPACK,
            self::VALUE_MNGTURKEY,
            self::VALUE_MONDIAL_RELAY,
            self::VALUE_MRW,
            self::VALUE_MSI,
            self::VALUE_NEMF,
            self::VALUE_ODFL,
            self::VALUE_OFFD,
            self::VALUE_ONTRACK,
            self::VALUE_OSTERREICHISCHE_POST_AG,
            self::VALUE_OVNT,
            self::VALUE_PARCEL_POOL,
            self::VALUE_PARCELFORCE,
            self::VALUE_PHILPOST,
            self::VALUE_PILOT,
            self::VALUE_PITD,
            self::VALUE_POCZTA_POLSKA,
            self::VALUE_POCZTEX,
            self::VALUE_POSTITALIANO,
            self::VALUE_POST_NL,
            self::VALUE_POST_NORD_NORWAY,
            self::VALUE_POSTE_ITALIANE,
            self::VALUE_PRESTIGE,
            self::VALUE_QUANTIUM,
            self::VALUE_RETL,
            self::VALUE_ROYAL_MAIL,
            self::VALUE_RRUN,
            self::VALUE_SAIA,
            self::VALUE_SDA,
            self::VALUE_SFC,
            self::VALUE_SFCEXPRESS,
            self::VALUE_SINGAPOREPOST,
            self::VALUE_SIODEMKA,
            self::VALUE_SIOLIAND_FONTANA,
            self::VALUE_SKYNET_MALAYSIA,
            self::VALUE_SMARTSEND,
            self::VALUE_SOGETRAS,
            self::VALUE_SPEDIAMO,
            self::VALUE_SPEE_DEE,
            self::VALUE_STAR_TRACK,
            self::VALUE_SUNTEK_EXPRESS_LTD,
            self::VALUE_SWISS_POST,
            self::VALUE_TELE,
            self::VALUE_TEMANDO,
            self::VALUE_THAILANDPOST,
            self::VALUE_TNT,
            self::VALUE_TNTEXPRESS,
            self::VALUE_TNTPOST,
            self::VALUE_TOLL,
            self::VALUE_TPG,
            self::VALUE_TWW,
            self::VALUE_UBI,
            self::VALUE_UKMAIL,
            self::VALUE_UPSMAIL_INNOVATIONS,
            self::VALUE_UPSC,
            self::VALUE_USFG,
            self::VALUE_USPSCE_P,
            self::VALUE_USPSPMI,
            self::VALUE_VIETNAM_POST,
            self::VALUE_VITR,
            self::VALUE_WATKINS,
            self::VALUE_WINIT,
            self::VALUE_WISE,
            self::VALUE_WNDIRECT,
            self::VALUE_WPX,
            self::VALUE_YANWEN,
            self::VALUE_YODEL,
            self::VALUE_YRC,
            self::VALUE_CUSTOM_CODE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
