<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StoreThemeArrayType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Set of Store themes.
 * @subpackage Structs
 */
class StoreThemeArrayType extends AbstractStructBase
{
    /**
     * The Theme
     * Meta informations extracted from the WSDL
     * - documentation: A Store theme.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\StoreThemeType[]
     */
    public $Theme;
    /**
     * The GenericColorSchemeArray
     * Meta informations extracted from the WSDL
     * - documentation: Set of color schemes. This set is for use with those themes that do not explicitly list a color scheme in the theme definition (these themes are also known as advanced themes).
     * - minOccurs: 0
     * @var \ArrayType\StoreColorSchemeArrayType
     */
    public $GenericColorSchemeArray;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for StoreThemeArrayType
     * @uses StoreThemeArrayType::setTheme()
     * @uses StoreThemeArrayType::setGenericColorSchemeArray()
     * @uses StoreThemeArrayType::setAny()
     * @param \StructType\StoreThemeType[] $theme
     * @param \ArrayType\StoreColorSchemeArrayType $genericColorSchemeArray
     * @param \DOMDocument $any
     */
    public function __construct(array $theme = array(), \ArrayType\StoreColorSchemeArrayType $genericColorSchemeArray = null, \DOMDocument $any = null)
    {
        $this
            ->setTheme($theme)
            ->setGenericColorSchemeArray($genericColorSchemeArray)
            ->setAny($any);
    }
    /**
     * Get Theme value
     * @return \StructType\StoreThemeType[]|null
     */
    public function getTheme()
    {
        return $this->Theme;
    }
    /**
     * Set Theme value
     * @throws \InvalidArgumentException
     * @param \StructType\StoreThemeType[] $theme
     * @return \StructType\StoreThemeArrayType
     */
    public function setTheme(array $theme = array())
    {
        foreach ($theme as $storeThemeArrayTypeThemeItem) {
            // validation for constraint: itemType
            if (!$storeThemeArrayTypeThemeItem instanceof \StructType\StoreThemeType) {
                throw new \InvalidArgumentException(sprintf('The Theme property can only contain items of \StructType\StoreThemeType, "%s" given', is_object($storeThemeArrayTypeThemeItem) ? get_class($storeThemeArrayTypeThemeItem) : gettype($storeThemeArrayTypeThemeItem)), __LINE__);
            }
        }
        $this->Theme = $theme;
        return $this;
    }
    /**
     * Add item to Theme value
     * @throws \InvalidArgumentException
     * @param \StructType\StoreThemeType $item
     * @return \StructType\StoreThemeArrayType
     */
    public function addToTheme(\StructType\StoreThemeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StoreThemeType) {
            throw new \InvalidArgumentException(sprintf('The Theme property can only contain items of \StructType\StoreThemeType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Theme[] = $item;
        return $this;
    }
    /**
     * Get GenericColorSchemeArray value
     * @return \ArrayType\StoreColorSchemeArrayType|null
     */
    public function getGenericColorSchemeArray()
    {
        return $this->GenericColorSchemeArray;
    }
    /**
     * Set GenericColorSchemeArray value
     * @param \ArrayType\StoreColorSchemeArrayType $genericColorSchemeArray
     * @return \StructType\StoreThemeArrayType
     */
    public function setGenericColorSchemeArray(\ArrayType\StoreColorSchemeArrayType $genericColorSchemeArray = null)
    {
        $this->GenericColorSchemeArray = $genericColorSchemeArray;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \StructType\StoreThemeArrayType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \StructType\StoreThemeArrayType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StoreThemeArrayType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
