<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlatShippingPreferencesType StructType
 * Meta informations extracted from the WSDL
 * - documentation: This type is deprecated.
 * @subpackage Structs
 */
class FlatShippingPreferencesType extends AbstractStructBase
{
    /**
     * The AmountPerAdditionalItem
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $AmountPerAdditionalItem;
    /**
     * The DeductionAmountPerAdditionalItem
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $DeductionAmountPerAdditionalItem;
    /**
     * The FlatRateInsuranceRangeCost
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - maxOccurs: 6
     * - minOccurs: 0
     * @var \StructType\FlatRateInsuranceRangeCostType[]
     */
    public $FlatRateInsuranceRangeCost;
    /**
     * The FlatShippingRateOption
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var string
     */
    public $FlatShippingRateOption;
    /**
     * The InsuranceOption
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var string
     */
    public $InsuranceOption;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for FlatShippingPreferencesType
     * @uses FlatShippingPreferencesType::setAmountPerAdditionalItem()
     * @uses FlatShippingPreferencesType::setDeductionAmountPerAdditionalItem()
     * @uses FlatShippingPreferencesType::setFlatRateInsuranceRangeCost()
     * @uses FlatShippingPreferencesType::setFlatShippingRateOption()
     * @uses FlatShippingPreferencesType::setInsuranceOption()
     * @uses FlatShippingPreferencesType::setAny()
     * @param \StructType\AmountType $amountPerAdditionalItem
     * @param \StructType\AmountType $deductionAmountPerAdditionalItem
     * @param \StructType\FlatRateInsuranceRangeCostType[] $flatRateInsuranceRangeCost
     * @param string $flatShippingRateOption
     * @param string $insuranceOption
     * @param \DOMDocument $any
     */
    public function __construct(\StructType\AmountType $amountPerAdditionalItem = null, \StructType\AmountType $deductionAmountPerAdditionalItem = null, array $flatRateInsuranceRangeCost = array(), $flatShippingRateOption = null, $insuranceOption = null, \DOMDocument $any = null)
    {
        $this
            ->setAmountPerAdditionalItem($amountPerAdditionalItem)
            ->setDeductionAmountPerAdditionalItem($deductionAmountPerAdditionalItem)
            ->setFlatRateInsuranceRangeCost($flatRateInsuranceRangeCost)
            ->setFlatShippingRateOption($flatShippingRateOption)
            ->setInsuranceOption($insuranceOption)
            ->setAny($any);
    }
    /**
     * Get AmountPerAdditionalItem value
     * @return \StructType\AmountType|null
     */
    public function getAmountPerAdditionalItem()
    {
        return $this->AmountPerAdditionalItem;
    }
    /**
     * Set AmountPerAdditionalItem value
     * @param \StructType\AmountType $amountPerAdditionalItem
     * @return \StructType\FlatShippingPreferencesType
     */
    public function setAmountPerAdditionalItem(\StructType\AmountType $amountPerAdditionalItem = null)
    {
        $this->AmountPerAdditionalItem = $amountPerAdditionalItem;
        return $this;
    }
    /**
     * Get DeductionAmountPerAdditionalItem value
     * @return \StructType\AmountType|null
     */
    public function getDeductionAmountPerAdditionalItem()
    {
        return $this->DeductionAmountPerAdditionalItem;
    }
    /**
     * Set DeductionAmountPerAdditionalItem value
     * @param \StructType\AmountType $deductionAmountPerAdditionalItem
     * @return \StructType\FlatShippingPreferencesType
     */
    public function setDeductionAmountPerAdditionalItem(\StructType\AmountType $deductionAmountPerAdditionalItem = null)
    {
        $this->DeductionAmountPerAdditionalItem = $deductionAmountPerAdditionalItem;
        return $this;
    }
    /**
     * Get FlatRateInsuranceRangeCost value
     * @return \StructType\FlatRateInsuranceRangeCostType[]|null
     */
    public function getFlatRateInsuranceRangeCost()
    {
        return $this->FlatRateInsuranceRangeCost;
    }
    /**
     * Set FlatRateInsuranceRangeCost value
     * @throws \InvalidArgumentException
     * @param \StructType\FlatRateInsuranceRangeCostType[] $flatRateInsuranceRangeCost
     * @return \StructType\FlatShippingPreferencesType
     */
    public function setFlatRateInsuranceRangeCost(array $flatRateInsuranceRangeCost = array())
    {
        foreach ($flatRateInsuranceRangeCost as $flatShippingPreferencesTypeFlatRateInsuranceRangeCostItem) {
            // validation for constraint: itemType
            if (!$flatShippingPreferencesTypeFlatRateInsuranceRangeCostItem instanceof \StructType\FlatRateInsuranceRangeCostType) {
                throw new \InvalidArgumentException(sprintf('The FlatRateInsuranceRangeCost property can only contain items of \StructType\FlatRateInsuranceRangeCostType, "%s" given', is_object($flatShippingPreferencesTypeFlatRateInsuranceRangeCostItem) ? get_class($flatShippingPreferencesTypeFlatRateInsuranceRangeCostItem) : gettype($flatShippingPreferencesTypeFlatRateInsuranceRangeCostItem)), __LINE__);
            }
        }
        $this->FlatRateInsuranceRangeCost = $flatRateInsuranceRangeCost;
        return $this;
    }
    /**
     * Add item to FlatRateInsuranceRangeCost value
     * @throws \InvalidArgumentException
     * @param \StructType\FlatRateInsuranceRangeCostType $item
     * @return \StructType\FlatShippingPreferencesType
     */
    public function addToFlatRateInsuranceRangeCost(\StructType\FlatRateInsuranceRangeCostType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FlatRateInsuranceRangeCostType) {
            throw new \InvalidArgumentException(sprintf('The FlatRateInsuranceRangeCost property can only contain items of \StructType\FlatRateInsuranceRangeCostType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FlatRateInsuranceRangeCost[] = $item;
        return $this;
    }
    /**
     * Get FlatShippingRateOption value
     * @return string|null
     */
    public function getFlatShippingRateOption()
    {
        return $this->FlatShippingRateOption;
    }
    /**
     * Set FlatShippingRateOption value
     * @uses \EnumType\FlatShippingRateOptionCodeType::valueIsValid()
     * @uses \EnumType\FlatShippingRateOptionCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $flatShippingRateOption
     * @return \StructType\FlatShippingPreferencesType
     */
    public function setFlatShippingRateOption($flatShippingRateOption = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FlatShippingRateOptionCodeType::valueIsValid($flatShippingRateOption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $flatShippingRateOption, implode(', ', \EnumType\FlatShippingRateOptionCodeType::getValidValues())), __LINE__);
        }
        $this->FlatShippingRateOption = $flatShippingRateOption;
        return $this;
    }
    /**
     * Get InsuranceOption value
     * @return string|null
     */
    public function getInsuranceOption()
    {
        return $this->InsuranceOption;
    }
    /**
     * Set InsuranceOption value
     * @uses \EnumType\InsuranceOptionCodeType::valueIsValid()
     * @uses \EnumType\InsuranceOptionCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $insuranceOption
     * @return \StructType\FlatShippingPreferencesType
     */
    public function setInsuranceOption($insuranceOption = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InsuranceOptionCodeType::valueIsValid($insuranceOption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $insuranceOption, implode(', ', \EnumType\InsuranceOptionCodeType::getValidValues())), __LINE__);
        }
        $this->InsuranceOption = $insuranceOption;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \StructType\FlatShippingPreferencesType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \StructType\FlatShippingPreferencesType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FlatShippingPreferencesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
