<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Identity ServiceType
 * @subpackage Services
 * @TestVJ 2
 * @version 1
 */
class Identity extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named identityCertification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IdentityCertification $parameters
     * @return \StructType\IdentityCertificationResponse|bool
     */
    public function identityCertification(\StructType\IdentityCertification $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->identityCertification($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IdentityCertificationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
