<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TWorkFileType StructType
 * @subpackage Structs
 */
class TWorkFileType extends AbstractStructBase
{
    /**
     * The WorkFileTypeId
     * @var int
     */
    public $WorkFileTypeId;
    /**
     * The WorkFileTypeLabel
     * @var string
     */
    public $WorkFileTypeLabel;
    /**
     * The WorkFileTypeColor
     * @var string
     */
    public $WorkFileTypeColor;
    /**
     * Constructor method for TWorkFileType
     * @uses TWorkFileType::setWorkFileTypeId()
     * @uses TWorkFileType::setWorkFileTypeLabel()
     * @uses TWorkFileType::setWorkFileTypeColor()
     * @param int $workFileTypeId
     * @param string $workFileTypeLabel
     * @param string $workFileTypeColor
     */
    public function __construct($workFileTypeId = null, $workFileTypeLabel = null, $workFileTypeColor = null)
    {
        $this
            ->setWorkFileTypeId($workFileTypeId)
            ->setWorkFileTypeLabel($workFileTypeLabel)
            ->setWorkFileTypeColor($workFileTypeColor);
    }
    /**
     * Get WorkFileTypeId value
     * @return int|null
     */
    public function getWorkFileTypeId()
    {
        return $this->WorkFileTypeId;
    }
    /**
     * Set WorkFileTypeId value
     * @param int $workFileTypeId
     * @return \StructType\TWorkFileType
     */
    public function setWorkFileTypeId($workFileTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($workFileTypeId) && !is_numeric($workFileTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($workFileTypeId)), __LINE__);
        }
        $this->WorkFileTypeId = $workFileTypeId;
        return $this;
    }
    /**
     * Get WorkFileTypeLabel value
     * @return string|null
     */
    public function getWorkFileTypeLabel()
    {
        return $this->WorkFileTypeLabel;
    }
    /**
     * Set WorkFileTypeLabel value
     * @param string $workFileTypeLabel
     * @return \StructType\TWorkFileType
     */
    public function setWorkFileTypeLabel($workFileTypeLabel = null)
    {
        // validation for constraint: string
        if (!is_null($workFileTypeLabel) && !is_string($workFileTypeLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workFileTypeLabel)), __LINE__);
        }
        $this->WorkFileTypeLabel = $workFileTypeLabel;
        return $this;
    }
    /**
     * Get WorkFileTypeColor value
     * @return string|null
     */
    public function getWorkFileTypeColor()
    {
        return $this->WorkFileTypeColor;
    }
    /**
     * Set WorkFileTypeColor value
     * @param string $workFileTypeColor
     * @return \StructType\TWorkFileType
     */
    public function setWorkFileTypeColor($workFileTypeColor = null)
    {
        // validation for constraint: string
        if (!is_null($workFileTypeColor) && !is_string($workFileTypeColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workFileTypeColor)), __LINE__);
        }
        $this->WorkFileTypeColor = $workFileTypeColor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TWorkFileType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
