<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TWorkFileResult StructType
 * @subpackage Structs
 */
class TWorkFileResult extends AbstractStructBase
{
    /**
     * The WorkFileList
     * Meta informations extracted from the WSDL
     * - arrayType: ns1:TWorkFile[]
     * - ref: soapenc:arrayType
     * @var \StructType\TWorkFile[]
     */
    public $WorkFileList;
    /**
     * The ResultCode
     * @var int
     */
    public $ResultCode;
    /**
     * The LastTicket
     * @var int
     */
    public $LastTicket;
    /**
     * Constructor method for TWorkFileResult
     * @uses TWorkFileResult::setWorkFileList()
     * @uses TWorkFileResult::setResultCode()
     * @uses TWorkFileResult::setLastTicket()
     * @param \StructType\TWorkFile[] $workFileList
     * @param int $resultCode
     * @param int $lastTicket
     */
    public function __construct(array $workFileList = array(), $resultCode = null, $lastTicket = null)
    {
        $this
            ->setWorkFileList($workFileList)
            ->setResultCode($resultCode)
            ->setLastTicket($lastTicket);
    }
    /**
     * Get WorkFileList value
     * @return \StructType\TWorkFile[]|null
     */
    public function getWorkFileList()
    {
        return $this->WorkFileList;
    }
    /**
     * Set WorkFileList value
     * @throws \InvalidArgumentException
     * @param \StructType\TWorkFile[] $workFileList
     * @return \StructType\TWorkFileResult
     */
    public function setWorkFileList(array $workFileList = array())
    {
        foreach ($workFileList as $tWorkFileResultWorkFileListItem) {
            // validation for constraint: itemType
            if (!$tWorkFileResultWorkFileListItem instanceof \StructType\TWorkFile) {
                throw new \InvalidArgumentException(sprintf('The WorkFileList property can only contain items of \StructType\TWorkFile, "%s" given', is_object($tWorkFileResultWorkFileListItem) ? get_class($tWorkFileResultWorkFileListItem) : gettype($tWorkFileResultWorkFileListItem)), __LINE__);
            }
        }
        $this->WorkFileList = $workFileList;
        return $this;
    }
    /**
     * Add item to WorkFileList value
     * @throws \InvalidArgumentException
     * @param \StructType\TWorkFile $item
     * @return \StructType\TWorkFileResult
     */
    public function addToWorkFileList(\StructType\TWorkFile $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TWorkFile) {
            throw new \InvalidArgumentException(sprintf('The WorkFileList property can only contain items of \StructType\TWorkFile, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WorkFileList[] = $item;
        return $this;
    }
    /**
     * Get ResultCode value
     * @return int|null
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param int $resultCode
     * @return \StructType\TWorkFileResult
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: int
        if (!is_null($resultCode) && !is_numeric($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get LastTicket value
     * @return int|null
     */
    public function getLastTicket()
    {
        return $this->LastTicket;
    }
    /**
     * Set LastTicket value
     * @param int $lastTicket
     * @return \StructType\TWorkFileResult
     */
    public function setLastTicket($lastTicket = null)
    {
        // validation for constraint: int
        if (!is_null($lastTicket) && !is_numeric($lastTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lastTicket)), __LINE__);
        }
        $this->LastTicket = $lastTicket;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TWorkFileResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
