<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TWarning StructType
 * @subpackage Structs
 */
class TWarning extends AbstractStructBase
{
    /**
     * The WarningId
     * @var int
     */
    public $WarningId;
    /**
     * The WarningName
     * @var string
     */
    public $WarningName;
    /**
     * Constructor method for TWarning
     * @uses TWarning::setWarningId()
     * @uses TWarning::setWarningName()
     * @param int $warningId
     * @param string $warningName
     */
    public function __construct($warningId = null, $warningName = null)
    {
        $this
            ->setWarningId($warningId)
            ->setWarningName($warningName);
    }
    /**
     * Get WarningId value
     * @return int|null
     */
    public function getWarningId()
    {
        return $this->WarningId;
    }
    /**
     * Set WarningId value
     * @param int $warningId
     * @return \StructType\TWarning
     */
    public function setWarningId($warningId = null)
    {
        // validation for constraint: int
        if (!is_null($warningId) && !is_numeric($warningId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($warningId)), __LINE__);
        }
        $this->WarningId = $warningId;
        return $this;
    }
    /**
     * Get WarningName value
     * @return string|null
     */
    public function getWarningName()
    {
        return $this->WarningName;
    }
    /**
     * Set WarningName value
     * @param string $warningName
     * @return \StructType\TWarning
     */
    public function setWarningName($warningName = null)
    {
        // validation for constraint: string
        if (!is_null($warningName) && !is_string($warningName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warningName)), __LINE__);
        }
        $this->WarningName = $warningName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TWarning
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
