<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TStaffMemberAbsence StructType
 * @subpackage Structs
 */
class TStaffMemberAbsence extends AbstractStructBase
{
    /**
     * The DateBegin
     * @var string
     */
    public $DateBegin;
    /**
     * The DateEnd
     * @var string
     */
    public $DateEnd;
    /**
     * The AbsenceId
     * @var int
     */
    public $AbsenceId;
    /**
     * Constructor method for TStaffMemberAbsence
     * @uses TStaffMemberAbsence::setDateBegin()
     * @uses TStaffMemberAbsence::setDateEnd()
     * @uses TStaffMemberAbsence::setAbsenceId()
     * @param string $dateBegin
     * @param string $dateEnd
     * @param int $absenceId
     */
    public function __construct($dateBegin = null, $dateEnd = null, $absenceId = null)
    {
        $this
            ->setDateBegin($dateBegin)
            ->setDateEnd($dateEnd)
            ->setAbsenceId($absenceId);
    }
    /**
     * Get DateBegin value
     * @return string|null
     */
    public function getDateBegin()
    {
        return $this->DateBegin;
    }
    /**
     * Set DateBegin value
     * @param string $dateBegin
     * @return \StructType\TStaffMemberAbsence
     */
    public function setDateBegin($dateBegin = null)
    {
        // validation for constraint: string
        if (!is_null($dateBegin) && !is_string($dateBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateBegin)), __LINE__);
        }
        $this->DateBegin = $dateBegin;
        return $this;
    }
    /**
     * Get DateEnd value
     * @return string|null
     */
    public function getDateEnd()
    {
        return $this->DateEnd;
    }
    /**
     * Set DateEnd value
     * @param string $dateEnd
     * @return \StructType\TStaffMemberAbsence
     */
    public function setDateEnd($dateEnd = null)
    {
        // validation for constraint: string
        if (!is_null($dateEnd) && !is_string($dateEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateEnd)), __LINE__);
        }
        $this->DateEnd = $dateEnd;
        return $this;
    }
    /**
     * Get AbsenceId value
     * @return int|null
     */
    public function getAbsenceId()
    {
        return $this->AbsenceId;
    }
    /**
     * Set AbsenceId value
     * @param int $absenceId
     * @return \StructType\TStaffMemberAbsence
     */
    public function setAbsenceId($absenceId = null)
    {
        // validation for constraint: int
        if (!is_null($absenceId) && !is_numeric($absenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($absenceId)), __LINE__);
        }
        $this->AbsenceId = $absenceId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TStaffMemberAbsence
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
