<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TStaffMember StructType
 * @subpackage Structs
 */
class TStaffMember extends AbstractStructBase
{
    /**
     * The MemAide
     * @var bool
     */
    public $MemAide;
    /**
     * The MemId
     * @var int
     */
    public $MemId;
    /**
     * The MemLastName
     * @var string
     */
    public $MemLastName;
    /**
     * The MemNoOrdre
     * @var int
     */
    public $MemNoOrdre;
    /**
     * The MemFirstName
     * @var string
     */
    public $MemFirstName;
    /**
     * The MemReference
     * @var string
     */
    public $MemReference;
    /**
     * The MemSpecialite
     * @var string
     */
    public $MemSpecialite;
    /**
     * The SitId
     * @var int
     */
    public $SitId;
    /**
     * The MemStaffMemberAbsenceList
     * Meta informations extracted from the WSDL
     * - arrayType: ns1:TStaffMemberAbsence[]
     * - ref: soapenc:arrayType
     * @var \StructType\TStaffMemberAbsence[]
     */
    public $MemStaffMemberAbsenceList;
    /**
     * Constructor method for TStaffMember
     * @uses TStaffMember::setMemAide()
     * @uses TStaffMember::setMemId()
     * @uses TStaffMember::setMemLastName()
     * @uses TStaffMember::setMemNoOrdre()
     * @uses TStaffMember::setMemFirstName()
     * @uses TStaffMember::setMemReference()
     * @uses TStaffMember::setMemSpecialite()
     * @uses TStaffMember::setSitId()
     * @uses TStaffMember::setMemStaffMemberAbsenceList()
     * @param bool $memAide
     * @param int $memId
     * @param string $memLastName
     * @param int $memNoOrdre
     * @param string $memFirstName
     * @param string $memReference
     * @param string $memSpecialite
     * @param int $sitId
     * @param \StructType\TStaffMemberAbsence[] $memStaffMemberAbsenceList
     */
    public function __construct($memAide = null, $memId = null, $memLastName = null, $memNoOrdre = null, $memFirstName = null, $memReference = null, $memSpecialite = null, $sitId = null, array $memStaffMemberAbsenceList = array())
    {
        $this
            ->setMemAide($memAide)
            ->setMemId($memId)
            ->setMemLastName($memLastName)
            ->setMemNoOrdre($memNoOrdre)
            ->setMemFirstName($memFirstName)
            ->setMemReference($memReference)
            ->setMemSpecialite($memSpecialite)
            ->setSitId($sitId)
            ->setMemStaffMemberAbsenceList($memStaffMemberAbsenceList);
    }
    /**
     * Get MemAide value
     * @return bool|null
     */
    public function getMemAide()
    {
        return $this->MemAide;
    }
    /**
     * Set MemAide value
     * @param bool $memAide
     * @return \StructType\TStaffMember
     */
    public function setMemAide($memAide = null)
    {
        // validation for constraint: boolean
        if (!is_null($memAide) && !is_bool($memAide)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($memAide)), __LINE__);
        }
        $this->MemAide = $memAide;
        return $this;
    }
    /**
     * Get MemId value
     * @return int|null
     */
    public function getMemId()
    {
        return $this->MemId;
    }
    /**
     * Set MemId value
     * @param int $memId
     * @return \StructType\TStaffMember
     */
    public function setMemId($memId = null)
    {
        // validation for constraint: int
        if (!is_null($memId) && !is_numeric($memId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($memId)), __LINE__);
        }
        $this->MemId = $memId;
        return $this;
    }
    /**
     * Get MemLastName value
     * @return string|null
     */
    public function getMemLastName()
    {
        return $this->MemLastName;
    }
    /**
     * Set MemLastName value
     * @param string $memLastName
     * @return \StructType\TStaffMember
     */
    public function setMemLastName($memLastName = null)
    {
        // validation for constraint: string
        if (!is_null($memLastName) && !is_string($memLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($memLastName)), __LINE__);
        }
        $this->MemLastName = $memLastName;
        return $this;
    }
    /**
     * Get MemNoOrdre value
     * @return int|null
     */
    public function getMemNoOrdre()
    {
        return $this->MemNoOrdre;
    }
    /**
     * Set MemNoOrdre value
     * @param int $memNoOrdre
     * @return \StructType\TStaffMember
     */
    public function setMemNoOrdre($memNoOrdre = null)
    {
        // validation for constraint: int
        if (!is_null($memNoOrdre) && !is_numeric($memNoOrdre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($memNoOrdre)), __LINE__);
        }
        $this->MemNoOrdre = $memNoOrdre;
        return $this;
    }
    /**
     * Get MemFirstName value
     * @return string|null
     */
    public function getMemFirstName()
    {
        return $this->MemFirstName;
    }
    /**
     * Set MemFirstName value
     * @param string $memFirstName
     * @return \StructType\TStaffMember
     */
    public function setMemFirstName($memFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($memFirstName) && !is_string($memFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($memFirstName)), __LINE__);
        }
        $this->MemFirstName = $memFirstName;
        return $this;
    }
    /**
     * Get MemReference value
     * @return string|null
     */
    public function getMemReference()
    {
        return $this->MemReference;
    }
    /**
     * Set MemReference value
     * @param string $memReference
     * @return \StructType\TStaffMember
     */
    public function setMemReference($memReference = null)
    {
        // validation for constraint: string
        if (!is_null($memReference) && !is_string($memReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($memReference)), __LINE__);
        }
        $this->MemReference = $memReference;
        return $this;
    }
    /**
     * Get MemSpecialite value
     * @return string|null
     */
    public function getMemSpecialite()
    {
        return $this->MemSpecialite;
    }
    /**
     * Set MemSpecialite value
     * @param string $memSpecialite
     * @return \StructType\TStaffMember
     */
    public function setMemSpecialite($memSpecialite = null)
    {
        // validation for constraint: string
        if (!is_null($memSpecialite) && !is_string($memSpecialite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($memSpecialite)), __LINE__);
        }
        $this->MemSpecialite = $memSpecialite;
        return $this;
    }
    /**
     * Get SitId value
     * @return int|null
     */
    public function getSitId()
    {
        return $this->SitId;
    }
    /**
     * Set SitId value
     * @param int $sitId
     * @return \StructType\TStaffMember
     */
    public function setSitId($sitId = null)
    {
        // validation for constraint: int
        if (!is_null($sitId) && !is_numeric($sitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sitId)), __LINE__);
        }
        $this->SitId = $sitId;
        return $this;
    }
    /**
     * Get MemStaffMemberAbsenceList value
     * @return \StructType\TStaffMemberAbsence[]|null
     */
    public function getMemStaffMemberAbsenceList()
    {
        return $this->MemStaffMemberAbsenceList;
    }
    /**
     * Set MemStaffMemberAbsenceList value
     * @throws \InvalidArgumentException
     * @param \StructType\TStaffMemberAbsence[] $memStaffMemberAbsenceList
     * @return \StructType\TStaffMember
     */
    public function setMemStaffMemberAbsenceList(array $memStaffMemberAbsenceList = array())
    {
        foreach ($memStaffMemberAbsenceList as $tStaffMemberMemStaffMemberAbsenceListItem) {
            // validation for constraint: itemType
            if (!$tStaffMemberMemStaffMemberAbsenceListItem instanceof \StructType\TStaffMemberAbsence) {
                throw new \InvalidArgumentException(sprintf('The MemStaffMemberAbsenceList property can only contain items of \StructType\TStaffMemberAbsence, "%s" given', is_object($tStaffMemberMemStaffMemberAbsenceListItem) ? get_class($tStaffMemberMemStaffMemberAbsenceListItem) : gettype($tStaffMemberMemStaffMemberAbsenceListItem)), __LINE__);
            }
        }
        $this->MemStaffMemberAbsenceList = $memStaffMemberAbsenceList;
        return $this;
    }
    /**
     * Add item to MemStaffMemberAbsenceList value
     * @throws \InvalidArgumentException
     * @param \StructType\TStaffMemberAbsence $item
     * @return \StructType\TStaffMember
     */
    public function addToMemStaffMemberAbsenceList(\StructType\TStaffMemberAbsence $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TStaffMemberAbsence) {
            throw new \InvalidArgumentException(sprintf('The MemStaffMemberAbsenceList property can only contain items of \StructType\TStaffMemberAbsence, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MemStaffMemberAbsenceList[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TStaffMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
