<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TReception StructType
 * @subpackage Structs
 */
class TReception extends AbstractStructBase
{
    /**
     * The RecId
     * @var int
     */
    public $RecId;
    /**
     * The RecReference
     * @var string
     */
    public $RecReference;
    /**
     * The RecName
     * @var string
     */
    public $RecName;
    /**
     * The Dates
     * Meta informations extracted from the WSDL
     * - arrayType: ns2:TAvailabilityDate[]
     * - ref: soapenc:arrayType
     * @var \StructType\TAvailabilityDate[]
     */
    public $Dates;
    /**
     * Constructor method for TReception
     * @uses TReception::setRecId()
     * @uses TReception::setRecReference()
     * @uses TReception::setRecName()
     * @uses TReception::setDates()
     * @param int $recId
     * @param string $recReference
     * @param string $recName
     * @param \StructType\TAvailabilityDate[] $dates
     */
    public function __construct($recId = null, $recReference = null, $recName = null, array $dates = array())
    {
        $this
            ->setRecId($recId)
            ->setRecReference($recReference)
            ->setRecName($recName)
            ->setDates($dates);
    }
    /**
     * Get RecId value
     * @return int|null
     */
    public function getRecId()
    {
        return $this->RecId;
    }
    /**
     * Set RecId value
     * @param int $recId
     * @return \StructType\TReception
     */
    public function setRecId($recId = null)
    {
        // validation for constraint: int
        if (!is_null($recId) && !is_numeric($recId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recId)), __LINE__);
        }
        $this->RecId = $recId;
        return $this;
    }
    /**
     * Get RecReference value
     * @return string|null
     */
    public function getRecReference()
    {
        return $this->RecReference;
    }
    /**
     * Set RecReference value
     * @param string $recReference
     * @return \StructType\TReception
     */
    public function setRecReference($recReference = null)
    {
        // validation for constraint: string
        if (!is_null($recReference) && !is_string($recReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recReference)), __LINE__);
        }
        $this->RecReference = $recReference;
        return $this;
    }
    /**
     * Get RecName value
     * @return string|null
     */
    public function getRecName()
    {
        return $this->RecName;
    }
    /**
     * Set RecName value
     * @param string $recName
     * @return \StructType\TReception
     */
    public function setRecName($recName = null)
    {
        // validation for constraint: string
        if (!is_null($recName) && !is_string($recName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recName)), __LINE__);
        }
        $this->RecName = $recName;
        return $this;
    }
    /**
     * Get Dates value
     * @return \StructType\TAvailabilityDate[]|null
     */
    public function getDates()
    {
        return $this->Dates;
    }
    /**
     * Set Dates value
     * @throws \InvalidArgumentException
     * @param \StructType\TAvailabilityDate[] $dates
     * @return \StructType\TReception
     */
    public function setDates(array $dates = array())
    {
        foreach ($dates as $tReceptionDatesItem) {
            // validation for constraint: itemType
            if (!$tReceptionDatesItem instanceof \StructType\TAvailabilityDate) {
                throw new \InvalidArgumentException(sprintf('The Dates property can only contain items of \StructType\TAvailabilityDate, "%s" given', is_object($tReceptionDatesItem) ? get_class($tReceptionDatesItem) : gettype($tReceptionDatesItem)), __LINE__);
            }
        }
        $this->Dates = $dates;
        return $this;
    }
    /**
     * Add item to Dates value
     * @throws \InvalidArgumentException
     * @param \StructType\TAvailabilityDate $item
     * @return \StructType\TReception
     */
    public function addToDates(\StructType\TAvailabilityDate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TAvailabilityDate) {
            throw new \InvalidArgumentException(sprintf('The Dates property can only contain items of \StructType\TAvailabilityDate, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Dates[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TReception
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
