<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TReceiving StructType
 * @subpackage Structs
 */
class TReceiving extends AbstractStructBase
{
    /**
     * The ReceivingId
     * @var int
     */
    public $ReceivingId;
    /**
     * The ReceivingName
     * @var string
     */
    public $ReceivingName;
    /**
     * The ReceivingEmail
     * @var string
     */
    public $ReceivingEmail;
    /**
     * The ReceivingCode
     * @var string
     */
    public $ReceivingCode;
    /**
     * The ProviderRecId
     * @var string
     */
    public $ProviderRecId;
    /**
     * Constructor method for TReceiving
     * @uses TReceiving::setReceivingId()
     * @uses TReceiving::setReceivingName()
     * @uses TReceiving::setReceivingEmail()
     * @uses TReceiving::setReceivingCode()
     * @uses TReceiving::setProviderRecId()
     * @param int $receivingId
     * @param string $receivingName
     * @param string $receivingEmail
     * @param string $receivingCode
     * @param string $providerRecId
     */
    public function __construct($receivingId = null, $receivingName = null, $receivingEmail = null, $receivingCode = null, $providerRecId = null)
    {
        $this
            ->setReceivingId($receivingId)
            ->setReceivingName($receivingName)
            ->setReceivingEmail($receivingEmail)
            ->setReceivingCode($receivingCode)
            ->setProviderRecId($providerRecId);
    }
    /**
     * Get ReceivingId value
     * @return int|null
     */
    public function getReceivingId()
    {
        return $this->ReceivingId;
    }
    /**
     * Set ReceivingId value
     * @param int $receivingId
     * @return \StructType\TReceiving
     */
    public function setReceivingId($receivingId = null)
    {
        // validation for constraint: int
        if (!is_null($receivingId) && !is_numeric($receivingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($receivingId)), __LINE__);
        }
        $this->ReceivingId = $receivingId;
        return $this;
    }
    /**
     * Get ReceivingName value
     * @return string|null
     */
    public function getReceivingName()
    {
        return $this->ReceivingName;
    }
    /**
     * Set ReceivingName value
     * @param string $receivingName
     * @return \StructType\TReceiving
     */
    public function setReceivingName($receivingName = null)
    {
        // validation for constraint: string
        if (!is_null($receivingName) && !is_string($receivingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receivingName)), __LINE__);
        }
        $this->ReceivingName = $receivingName;
        return $this;
    }
    /**
     * Get ReceivingEmail value
     * @return string|null
     */
    public function getReceivingEmail()
    {
        return $this->ReceivingEmail;
    }
    /**
     * Set ReceivingEmail value
     * @param string $receivingEmail
     * @return \StructType\TReceiving
     */
    public function setReceivingEmail($receivingEmail = null)
    {
        // validation for constraint: string
        if (!is_null($receivingEmail) && !is_string($receivingEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receivingEmail)), __LINE__);
        }
        $this->ReceivingEmail = $receivingEmail;
        return $this;
    }
    /**
     * Get ReceivingCode value
     * @return string|null
     */
    public function getReceivingCode()
    {
        return $this->ReceivingCode;
    }
    /**
     * Set ReceivingCode value
     * @param string $receivingCode
     * @return \StructType\TReceiving
     */
    public function setReceivingCode($receivingCode = null)
    {
        // validation for constraint: string
        if (!is_null($receivingCode) && !is_string($receivingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receivingCode)), __LINE__);
        }
        $this->ReceivingCode = $receivingCode;
        return $this;
    }
    /**
     * Get ProviderRecId value
     * @return string|null
     */
    public function getProviderRecId()
    {
        return $this->ProviderRecId;
    }
    /**
     * Set ProviderRecId value
     * @param string $providerRecId
     * @return \StructType\TReceiving
     */
    public function setProviderRecId($providerRecId = null)
    {
        // validation for constraint: string
        if (!is_null($providerRecId) && !is_string($providerRecId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($providerRecId)), __LINE__);
        }
        $this->ProviderRecId = $providerRecId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TReceiving
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
