<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TDMSObjects StructType
 * @subpackage Structs
 */
class TDMSObjects extends AbstractStructBase
{
    /**
     * The ClientList
     * Meta informations extracted from the WSDL
     * - arrayType: ns1:TClient[]
     * - ref: soapenc:arrayType
     * @var \StructType\TClient[]
     */
    public $ClientList;
    /**
     * The VehicleList
     * Meta informations extracted from the WSDL
     * - arrayType: ns1:TVehicle[]
     * - ref: soapenc:arrayType
     * @var \StructType\TVehicle[]
     */
    public $VehicleList;
    /**
     * The RendezVousList
     * Meta informations extracted from the WSDL
     * - arrayType: ns1:TRendezVous[]
     * - ref: soapenc:arrayType
     * @var \StructType\TRendezVous[]
     */
    public $RendezVousList;
    /**
     * The ResultCode
     * @var int
     */
    public $ResultCode;
    /**
     * The LastTicket
     * @var int
     */
    public $LastTicket;
    /**
     * Constructor method for TDMSObjects
     * @uses TDMSObjects::setClientList()
     * @uses TDMSObjects::setVehicleList()
     * @uses TDMSObjects::setRendezVousList()
     * @uses TDMSObjects::setResultCode()
     * @uses TDMSObjects::setLastTicket()
     * @param \StructType\TClient[] $clientList
     * @param \StructType\TVehicle[] $vehicleList
     * @param \StructType\TRendezVous[] $rendezVousList
     * @param int $resultCode
     * @param int $lastTicket
     */
    public function __construct(array $clientList = array(), array $vehicleList = array(), array $rendezVousList = array(), $resultCode = null, $lastTicket = null)
    {
        $this
            ->setClientList($clientList)
            ->setVehicleList($vehicleList)
            ->setRendezVousList($rendezVousList)
            ->setResultCode($resultCode)
            ->setLastTicket($lastTicket);
    }
    /**
     * Get ClientList value
     * @return \StructType\TClient[]|null
     */
    public function getClientList()
    {
        return $this->ClientList;
    }
    /**
     * Set ClientList value
     * @throws \InvalidArgumentException
     * @param \StructType\TClient[] $clientList
     * @return \StructType\TDMSObjects
     */
    public function setClientList(array $clientList = array())
    {
        foreach ($clientList as $tDMSObjectsClientListItem) {
            // validation for constraint: itemType
            if (!$tDMSObjectsClientListItem instanceof \StructType\TClient) {
                throw new \InvalidArgumentException(sprintf('The ClientList property can only contain items of \StructType\TClient, "%s" given', is_object($tDMSObjectsClientListItem) ? get_class($tDMSObjectsClientListItem) : gettype($tDMSObjectsClientListItem)), __LINE__);
            }
        }
        $this->ClientList = $clientList;
        return $this;
    }
    /**
     * Add item to ClientList value
     * @throws \InvalidArgumentException
     * @param \StructType\TClient $item
     * @return \StructType\TDMSObjects
     */
    public function addToClientList(\StructType\TClient $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TClient) {
            throw new \InvalidArgumentException(sprintf('The ClientList property can only contain items of \StructType\TClient, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ClientList[] = $item;
        return $this;
    }
    /**
     * Get VehicleList value
     * @return \StructType\TVehicle[]|null
     */
    public function getVehicleList()
    {
        return $this->VehicleList;
    }
    /**
     * Set VehicleList value
     * @throws \InvalidArgumentException
     * @param \StructType\TVehicle[] $vehicleList
     * @return \StructType\TDMSObjects
     */
    public function setVehicleList(array $vehicleList = array())
    {
        foreach ($vehicleList as $tDMSObjectsVehicleListItem) {
            // validation for constraint: itemType
            if (!$tDMSObjectsVehicleListItem instanceof \StructType\TVehicle) {
                throw new \InvalidArgumentException(sprintf('The VehicleList property can only contain items of \StructType\TVehicle, "%s" given', is_object($tDMSObjectsVehicleListItem) ? get_class($tDMSObjectsVehicleListItem) : gettype($tDMSObjectsVehicleListItem)), __LINE__);
            }
        }
        $this->VehicleList = $vehicleList;
        return $this;
    }
    /**
     * Add item to VehicleList value
     * @throws \InvalidArgumentException
     * @param \StructType\TVehicle $item
     * @return \StructType\TDMSObjects
     */
    public function addToVehicleList(\StructType\TVehicle $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TVehicle) {
            throw new \InvalidArgumentException(sprintf('The VehicleList property can only contain items of \StructType\TVehicle, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VehicleList[] = $item;
        return $this;
    }
    /**
     * Get RendezVousList value
     * @return \StructType\TRendezVous[]|null
     */
    public function getRendezVousList()
    {
        return $this->RendezVousList;
    }
    /**
     * Set RendezVousList value
     * @throws \InvalidArgumentException
     * @param \StructType\TRendezVous[] $rendezVousList
     * @return \StructType\TDMSObjects
     */
    public function setRendezVousList(array $rendezVousList = array())
    {
        foreach ($rendezVousList as $tDMSObjectsRendezVousListItem) {
            // validation for constraint: itemType
            if (!$tDMSObjectsRendezVousListItem instanceof \StructType\TRendezVous) {
                throw new \InvalidArgumentException(sprintf('The RendezVousList property can only contain items of \StructType\TRendezVous, "%s" given', is_object($tDMSObjectsRendezVousListItem) ? get_class($tDMSObjectsRendezVousListItem) : gettype($tDMSObjectsRendezVousListItem)), __LINE__);
            }
        }
        $this->RendezVousList = $rendezVousList;
        return $this;
    }
    /**
     * Add item to RendezVousList value
     * @throws \InvalidArgumentException
     * @param \StructType\TRendezVous $item
     * @return \StructType\TDMSObjects
     */
    public function addToRendezVousList(\StructType\TRendezVous $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TRendezVous) {
            throw new \InvalidArgumentException(sprintf('The RendezVousList property can only contain items of \StructType\TRendezVous, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RendezVousList[] = $item;
        return $this;
    }
    /**
     * Get ResultCode value
     * @return int|null
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param int $resultCode
     * @return \StructType\TDMSObjects
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: int
        if (!is_null($resultCode) && !is_numeric($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get LastTicket value
     * @return int|null
     */
    public function getLastTicket()
    {
        return $this->LastTicket;
    }
    /**
     * Set LastTicket value
     * @param int $lastTicket
     * @return \StructType\TDMSObjects
     */
    public function setLastTicket($lastTicket = null)
    {
        // validation for constraint: int
        if (!is_null($lastTicket) && !is_numeric($lastTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lastTicket)), __LINE__);
        }
        $this->LastTicket = $lastTicket;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TDMSObjects
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
