<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TAvailabilityInfo StructType
 * @subpackage Structs
 */
class TAvailabilityInfo extends AbstractStructBase
{
    /**
     * The IsAvailable
     * @var bool
     */
    public $IsAvailable;
    /**
     * The IsAvailableOnline
     * @var bool
     */
    public $IsAvailableOnline;
    /**
     * The CurrentDate
     * @var string
     */
    public $CurrentDate;
    /**
     * The TimeAvailable
     * @var float
     */
    public $TimeAvailable;
    /**
     * The Charge
     * @var float
     */
    public $Charge;
    /**
     * Constructor method for TAvailabilityInfo
     * @uses TAvailabilityInfo::setIsAvailable()
     * @uses TAvailabilityInfo::setIsAvailableOnline()
     * @uses TAvailabilityInfo::setCurrentDate()
     * @uses TAvailabilityInfo::setTimeAvailable()
     * @uses TAvailabilityInfo::setCharge()
     * @param bool $isAvailable
     * @param bool $isAvailableOnline
     * @param string $currentDate
     * @param float $timeAvailable
     * @param float $charge
     */
    public function __construct($isAvailable = null, $isAvailableOnline = null, $currentDate = null, $timeAvailable = null, $charge = null)
    {
        $this
            ->setIsAvailable($isAvailable)
            ->setIsAvailableOnline($isAvailableOnline)
            ->setCurrentDate($currentDate)
            ->setTimeAvailable($timeAvailable)
            ->setCharge($charge);
    }
    /**
     * Get IsAvailable value
     * @return bool|null
     */
    public function getIsAvailable()
    {
        return $this->IsAvailable;
    }
    /**
     * Set IsAvailable value
     * @param bool $isAvailable
     * @return \StructType\TAvailabilityInfo
     */
    public function setIsAvailable($isAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailable) && !is_bool($isAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAvailable)), __LINE__);
        }
        $this->IsAvailable = $isAvailable;
        return $this;
    }
    /**
     * Get IsAvailableOnline value
     * @return bool|null
     */
    public function getIsAvailableOnline()
    {
        return $this->IsAvailableOnline;
    }
    /**
     * Set IsAvailableOnline value
     * @param bool $isAvailableOnline
     * @return \StructType\TAvailabilityInfo
     */
    public function setIsAvailableOnline($isAvailableOnline = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableOnline) && !is_bool($isAvailableOnline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAvailableOnline)), __LINE__);
        }
        $this->IsAvailableOnline = $isAvailableOnline;
        return $this;
    }
    /**
     * Get CurrentDate value
     * @return string|null
     */
    public function getCurrentDate()
    {
        return $this->CurrentDate;
    }
    /**
     * Set CurrentDate value
     * @param string $currentDate
     * @return \StructType\TAvailabilityInfo
     */
    public function setCurrentDate($currentDate = null)
    {
        // validation for constraint: string
        if (!is_null($currentDate) && !is_string($currentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currentDate)), __LINE__);
        }
        $this->CurrentDate = $currentDate;
        return $this;
    }
    /**
     * Get TimeAvailable value
     * @return float|null
     */
    public function getTimeAvailable()
    {
        return $this->TimeAvailable;
    }
    /**
     * Set TimeAvailable value
     * @param float $timeAvailable
     * @return \StructType\TAvailabilityInfo
     */
    public function setTimeAvailable($timeAvailable = null)
    {
        $this->TimeAvailable = $timeAvailable;
        return $this;
    }
    /**
     * Get Charge value
     * @return float|null
     */
    public function getCharge()
    {
        return $this->Charge;
    }
    /**
     * Set Charge value
     * @param float $charge
     * @return \StructType\TAvailabilityInfo
     */
    public function setCharge($charge = null)
    {
        $this->Charge = $charge;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TAvailabilityInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
