<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TAvailabilityDate StructType
 * @subpackage Structs
 */
class TAvailabilityDate extends AbstractStructBase
{
    /**
     * The CurrentDate
     * @var string
     */
    public $CurrentDate;
    /**
     * The TimeSlots
     * Meta informations extracted from the WSDL
     * - arrayType: ns2:TAvailabilityTimeSlot[]
     * - ref: soapenc:arrayType
     * @var \StructType\TAvailabilityTimeSlot[]
     */
    public $TimeSlots;
    /**
     * Constructor method for TAvailabilityDate
     * @uses TAvailabilityDate::setCurrentDate()
     * @uses TAvailabilityDate::setTimeSlots()
     * @param string $currentDate
     * @param \StructType\TAvailabilityTimeSlot[] $timeSlots
     */
    public function __construct($currentDate = null, array $timeSlots = array())
    {
        $this
            ->setCurrentDate($currentDate)
            ->setTimeSlots($timeSlots);
    }
    /**
     * Get CurrentDate value
     * @return string|null
     */
    public function getCurrentDate()
    {
        return $this->CurrentDate;
    }
    /**
     * Set CurrentDate value
     * @param string $currentDate
     * @return \StructType\TAvailabilityDate
     */
    public function setCurrentDate($currentDate = null)
    {
        // validation for constraint: string
        if (!is_null($currentDate) && !is_string($currentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currentDate)), __LINE__);
        }
        $this->CurrentDate = $currentDate;
        return $this;
    }
    /**
     * Get TimeSlots value
     * @return \StructType\TAvailabilityTimeSlot[]|null
     */
    public function getTimeSlots()
    {
        return $this->TimeSlots;
    }
    /**
     * Set TimeSlots value
     * @throws \InvalidArgumentException
     * @param \StructType\TAvailabilityTimeSlot[] $timeSlots
     * @return \StructType\TAvailabilityDate
     */
    public function setTimeSlots(array $timeSlots = array())
    {
        foreach ($timeSlots as $tAvailabilityDateTimeSlotsItem) {
            // validation for constraint: itemType
            if (!$tAvailabilityDateTimeSlotsItem instanceof \StructType\TAvailabilityTimeSlot) {
                throw new \InvalidArgumentException(sprintf('The TimeSlots property can only contain items of \StructType\TAvailabilityTimeSlot, "%s" given', is_object($tAvailabilityDateTimeSlotsItem) ? get_class($tAvailabilityDateTimeSlotsItem) : gettype($tAvailabilityDateTimeSlotsItem)), __LINE__);
            }
        }
        $this->TimeSlots = $timeSlots;
        return $this;
    }
    /**
     * Add item to TimeSlots value
     * @throws \InvalidArgumentException
     * @param \StructType\TAvailabilityTimeSlot $item
     * @return \StructType\TAvailabilityDate
     */
    public function addToTimeSlots(\StructType\TAvailabilityTimeSlot $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TAvailabilityTimeSlot) {
            throw new \InvalidArgumentException(sprintf('The TimeSlots property can only contain items of \StructType\TAvailabilityTimeSlot, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TimeSlots[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TAvailabilityDate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
