<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TAction StructType
 * @subpackage Structs
 */
class TAction extends AbstractStructBase
{
    /**
     * The ActionName
     * @var string
     */
    public $ActionName;
    /**
     * The ActionCode
     * @var string
     */
    public $ActionCode;
    /**
     * The ActionCode2
     * @var string
     */
    public $ActionCode2;
    /**
     * The ActionCodeDMS
     * @var string
     */
    public $ActionCodeDMS;
    /**
     * The CategoryActionCode
     * @var string
     */
    public $CategoryActionCode;
    /**
     * The ActionDuration
     * @var int
     */
    public $ActionDuration;
    /**
     * The ActionId
     * @var int
     */
    public $ActionId;
    /**
     * The GroupActionId
     * @var int
     */
    public $GroupActionId;
    /**
     * Constructor method for TAction
     * @uses TAction::setActionName()
     * @uses TAction::setActionCode()
     * @uses TAction::setActionCode2()
     * @uses TAction::setActionCodeDMS()
     * @uses TAction::setCategoryActionCode()
     * @uses TAction::setActionDuration()
     * @uses TAction::setActionId()
     * @uses TAction::setGroupActionId()
     * @param string $actionName
     * @param string $actionCode
     * @param string $actionCode2
     * @param string $actionCodeDMS
     * @param string $categoryActionCode
     * @param int $actionDuration
     * @param int $actionId
     * @param int $groupActionId
     */
    public function __construct($actionName = null, $actionCode = null, $actionCode2 = null, $actionCodeDMS = null, $categoryActionCode = null, $actionDuration = null, $actionId = null, $groupActionId = null)
    {
        $this
            ->setActionName($actionName)
            ->setActionCode($actionCode)
            ->setActionCode2($actionCode2)
            ->setActionCodeDMS($actionCodeDMS)
            ->setCategoryActionCode($categoryActionCode)
            ->setActionDuration($actionDuration)
            ->setActionId($actionId)
            ->setGroupActionId($groupActionId);
    }
    /**
     * Get ActionName value
     * @return string|null
     */
    public function getActionName()
    {
        return $this->ActionName;
    }
    /**
     * Set ActionName value
     * @param string $actionName
     * @return \StructType\TAction
     */
    public function setActionName($actionName = null)
    {
        // validation for constraint: string
        if (!is_null($actionName) && !is_string($actionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actionName)), __LINE__);
        }
        $this->ActionName = $actionName;
        return $this;
    }
    /**
     * Get ActionCode value
     * @return string|null
     */
    public function getActionCode()
    {
        return $this->ActionCode;
    }
    /**
     * Set ActionCode value
     * @param string $actionCode
     * @return \StructType\TAction
     */
    public function setActionCode($actionCode = null)
    {
        // validation for constraint: string
        if (!is_null($actionCode) && !is_string($actionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actionCode)), __LINE__);
        }
        $this->ActionCode = $actionCode;
        return $this;
    }
    /**
     * Get ActionCode2 value
     * @return string|null
     */
    public function getActionCode2()
    {
        return $this->ActionCode2;
    }
    /**
     * Set ActionCode2 value
     * @param string $actionCode2
     * @return \StructType\TAction
     */
    public function setActionCode2($actionCode2 = null)
    {
        // validation for constraint: string
        if (!is_null($actionCode2) && !is_string($actionCode2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actionCode2)), __LINE__);
        }
        $this->ActionCode2 = $actionCode2;
        return $this;
    }
    /**
     * Get ActionCodeDMS value
     * @return string|null
     */
    public function getActionCodeDMS()
    {
        return $this->ActionCodeDMS;
    }
    /**
     * Set ActionCodeDMS value
     * @param string $actionCodeDMS
     * @return \StructType\TAction
     */
    public function setActionCodeDMS($actionCodeDMS = null)
    {
        // validation for constraint: string
        if (!is_null($actionCodeDMS) && !is_string($actionCodeDMS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actionCodeDMS)), __LINE__);
        }
        $this->ActionCodeDMS = $actionCodeDMS;
        return $this;
    }
    /**
     * Get CategoryActionCode value
     * @return string|null
     */
    public function getCategoryActionCode()
    {
        return $this->CategoryActionCode;
    }
    /**
     * Set CategoryActionCode value
     * @param string $categoryActionCode
     * @return \StructType\TAction
     */
    public function setCategoryActionCode($categoryActionCode = null)
    {
        // validation for constraint: string
        if (!is_null($categoryActionCode) && !is_string($categoryActionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($categoryActionCode)), __LINE__);
        }
        $this->CategoryActionCode = $categoryActionCode;
        return $this;
    }
    /**
     * Get ActionDuration value
     * @return int|null
     */
    public function getActionDuration()
    {
        return $this->ActionDuration;
    }
    /**
     * Set ActionDuration value
     * @param int $actionDuration
     * @return \StructType\TAction
     */
    public function setActionDuration($actionDuration = null)
    {
        // validation for constraint: int
        if (!is_null($actionDuration) && !is_numeric($actionDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($actionDuration)), __LINE__);
        }
        $this->ActionDuration = $actionDuration;
        return $this;
    }
    /**
     * Get ActionId value
     * @return int|null
     */
    public function getActionId()
    {
        return $this->ActionId;
    }
    /**
     * Set ActionId value
     * @param int $actionId
     * @return \StructType\TAction
     */
    public function setActionId($actionId = null)
    {
        // validation for constraint: int
        if (!is_null($actionId) && !is_numeric($actionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($actionId)), __LINE__);
        }
        $this->ActionId = $actionId;
        return $this;
    }
    /**
     * Get GroupActionId value
     * @return int|null
     */
    public function getGroupActionId()
    {
        return $this->GroupActionId;
    }
    /**
     * Set GroupActionId value
     * @param int $groupActionId
     * @return \StructType\TAction
     */
    public function setGroupActionId($groupActionId = null)
    {
        // validation for constraint: int
        if (!is_null($groupActionId) && !is_numeric($groupActionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($groupActionId)), __LINE__);
        }
        $this->GroupActionId = $groupActionId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TAction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
