<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named setAction
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $categoryActionId
     * @param string $categoryActionCode
     * @param string $groupActionId
     * @param string $actionId
     * @param string $actionCode
     * @param string $actionName
     * @param string $actionCodeDMS
     * @param string $actionDuration
     * @param string $actionCostWkForce
     * @param string $actionWkForceInvoice
     * @param string $actionCostPiece
     * @param string $actionOtherCost
     * @param string $actionOtherInvoice
     * @param string $codeLanguage
     * @param string $providerName
     * @return \StructType\TWSResult|bool
     */
    public function setAction($entId, $entKey, $dMSId, $categoryActionId, $categoryActionCode, $groupActionId, $actionId, $actionCode, $actionName, $actionCodeDMS, $actionDuration, $actionCostWkForce, $actionWkForceInvoice, $actionCostPiece, $actionOtherCost, $actionOtherInvoice, $codeLanguage, $providerName)
    {
        try {
            $this->setResult(self::getSoapClient()->setAction($entId, $entKey, $dMSId, $categoryActionId, $categoryActionCode, $groupActionId, $actionId, $actionCode, $actionName, $actionCodeDMS, $actionDuration, $actionCostWkForce, $actionWkForceInvoice, $actionCostPiece, $actionOtherCost, $actionOtherInvoice, $codeLanguage, $providerName));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setClient
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $cliDMSId
     * @param string $cliTitle
     * @param string $cliFamName
     * @param string $cliFirName
     * @param string $cliAddr1
     * @param string $cliAddr2
     * @param string $cliPC
     * @param string $cliCity
     * @param string $cliHomePhone
     * @param string $cliCellPhone
     * @param string $cliWorkPhone
     * @param string $cliFax
     * @param string $cliEmail
     * @param string $cliAccountType
     * @param string $cliState
     * @param string $cliCountry
     * @param string $cliTags
     * @param string $cliDoNotText
     * @param string $cliDoNotEmail
     * @param string $cliDoNotPhone
     * @param string $cliCashPayment
     * @param string $cliLocked
     * @param string $cliLanguage
     * @param string $cliActive
     * @param string $providerName
     * @param string $providerCliId
     * @param string $cliId
     * @return \StructType\TWSResult|bool
     */
    public function setClient($entId, $entKey, $dMSId, $cliDMSId, $cliTitle, $cliFamName, $cliFirName, $cliAddr1, $cliAddr2, $cliPC, $cliCity, $cliHomePhone, $cliCellPhone, $cliWorkPhone, $cliFax, $cliEmail, $cliAccountType, $cliState, $cliCountry, $cliTags, $cliDoNotText, $cliDoNotEmail, $cliDoNotPhone, $cliCashPayment, $cliLocked, $cliLanguage, $cliActive, $providerName, $providerCliId, $cliId)
    {
        try {
            $this->setResult(self::getSoapClient()->setClient($entId, $entKey, $dMSId, $cliDMSId, $cliTitle, $cliFamName, $cliFirName, $cliAddr1, $cliAddr2, $cliPC, $cliCity, $cliHomePhone, $cliCellPhone, $cliWorkPhone, $cliFax, $cliEmail, $cliAccountType, $cliState, $cliCountry, $cliTags, $cliDoNotText, $cliDoNotEmail, $cliDoNotPhone, $cliCashPayment, $cliLocked, $cliLanguage, $cliActive, $providerName, $providerCliId, $cliId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setContact
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $cliDMSId
     * @param string $contactTitle
     * @param string $contactFamName
     * @param string $contactFirName
     * @param string $contactAddr1
     * @param string $contactAddr2
     * @param string $contactPC
     * @param string $contactCity
     * @param string $contactHomePhone
     * @param string $contactCellPhone
     * @param string $contactWorkPhone
     * @param string $contactFax
     * @param string $contactEmail
     * @param string $contactAccountType
     * @param string $contactState
     * @param string $contactCountry
     * @param string $contactTags
     * @param string $contactDoNotText
     * @param string $contactDoNotEmail
     * @param string $contactDoNotPhone
     * @param string $contactCashPayment
     * @param string $contactLocked
     * @param string $contactLanguage
     * @param string $contactActive
     * @param string $providerName
     * @param string $providerContactCliId
     * @param string $providerCliId
     * @param string $cliId
     * @param string $contactCliId
     * @return \StructType\TWSResult|bool
     */
    public function setContact($entId, $entKey, $dMSId, $cliDMSId, $contactTitle, $contactFamName, $contactFirName, $contactAddr1, $contactAddr2, $contactPC, $contactCity, $contactHomePhone, $contactCellPhone, $contactWorkPhone, $contactFax, $contactEmail, $contactAccountType, $contactState, $contactCountry, $contactTags, $contactDoNotText, $contactDoNotEmail, $contactDoNotPhone, $contactCashPayment, $contactLocked, $contactLanguage, $contactActive, $providerName, $providerContactCliId, $providerCliId, $cliId, $contactCliId)
    {
        try {
            $this->setResult(self::getSoapClient()->setContact($entId, $entKey, $dMSId, $cliDMSId, $contactTitle, $contactFamName, $contactFirName, $contactAddr1, $contactAddr2, $contactPC, $contactCity, $contactHomePhone, $contactCellPhone, $contactWorkPhone, $contactFax, $contactEmail, $contactAccountType, $contactState, $contactCountry, $contactTags, $contactDoNotText, $contactDoNotEmail, $contactDoNotPhone, $contactCashPayment, $contactLocked, $contactLanguage, $contactActive, $providerName, $providerContactCliId, $providerCliId, $cliId, $contactCliId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setVehicle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $cliDMSId
     * @param string $vehVIN
     * @param string $vehRegNum
     * @param string $vehMake
     * @param string $vehModel
     * @param string $vehType
     * @param string $vehKm
     * @param string $vehPower
     * @param string $vehTaxPower
     * @param string $vehSeats
     * @param string $vehRegDate
     * @param string $vehYear
     * @param string $vehColor
     * @param string $vehPaint
     * @param string $vehUsedCarNum
     * @param string $vehEngineNum
     * @param string $vehState
     * @param string $vehFuelLevel
     * @param string $vehModelCode
     * @param string $vehNoStock
     * @param string $vehAdvisor
     * @param string $vehTags
     * @param string $vehActive
     * @param string $providerName
     * @param string $providerCliId
     * @param string $providerVehId
     * @param string $cliId
     * @param string $vehId
     * @return \StructType\TWSResult|bool
     */
    public function setVehicle($entId, $entKey, $dMSId, $cliDMSId, $vehVIN, $vehRegNum, $vehMake, $vehModel, $vehType, $vehKm, $vehPower, $vehTaxPower, $vehSeats, $vehRegDate, $vehYear, $vehColor, $vehPaint, $vehUsedCarNum, $vehEngineNum, $vehState, $vehFuelLevel, $vehModelCode, $vehNoStock, $vehAdvisor, $vehTags, $vehActive, $providerName, $providerCliId, $providerVehId, $cliId, $vehId)
    {
        try {
            $this->setResult(self::getSoapClient()->setVehicle($entId, $entKey, $dMSId, $cliDMSId, $vehVIN, $vehRegNum, $vehMake, $vehModel, $vehType, $vehKm, $vehPower, $vehTaxPower, $vehSeats, $vehRegDate, $vehYear, $vehColor, $vehPaint, $vehUsedCarNum, $vehEngineNum, $vehState, $vehFuelLevel, $vehModelCode, $vehNoStock, $vehAdvisor, $vehTags, $vehActive, $providerName, $providerCliId, $providerVehId, $cliId, $vehId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setRdv
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $rdvId
     * @param string $rdvRONum
     * @param string $dMSId
     * @param string $siteCode
     * @param string $receiverCode
     * @param string $workshopCode
     * @param string $cliDMSId
     * @param string $vehVIN
     * @param string $vehRegNum
     * @param string $rdvType
     * @param string $rdvDuration
     * @param string $rdvState
     * @param string $rdvPartsState
     * @param string $rdvStart
     * @param string $rdvFinish
     * @param string $rdvReceivingComment
     * @param string $rdvWorkshopComment
     * @param string $rdvPartsComment
     * @param string $rdvLoaner
     * @param string $rdvSoldHours
     * @param string $rdvWorkHours
     * @param string $rdvSaleTotal
     * @param string $rdvTicketNum
     * @param string $workLineList
     * @param string $providerName
     * @param string $providerCliId
     * @param string $providerVehId
     * @param string $providerRdvId
     * @param string $rdvBookedOnline
     * @param string $vehId
     * @param string $sendEmail
     * @param string $sendSms
     * @param string $siteId
     * @param string $workShopId
     * @param string $rdvCliWaits
     * @param string $rdvActive
     * @param string $rdvNoShowCustomer
     * @param string $rdvMovementsComment
     * @param string $vehStockNum
     * @param string $rdvStoppedVehicle
     * @param string $rdvStoppedIndicatorId
     * @param string $receiverId
     * @param string $contactCliId
     * @return \StructType\TWSResult|bool
     */
    public function setRdv($entId, $entKey, $rdvId, $rdvRONum, $dMSId, $siteCode, $receiverCode, $workshopCode, $cliDMSId, $vehVIN, $vehRegNum, $rdvType, $rdvDuration, $rdvState, $rdvPartsState, $rdvStart, $rdvFinish, $rdvReceivingComment, $rdvWorkshopComment, $rdvPartsComment, $rdvLoaner, $rdvSoldHours, $rdvWorkHours, $rdvSaleTotal, $rdvTicketNum, $workLineList, $providerName, $providerCliId, $providerVehId, $providerRdvId, $rdvBookedOnline, $vehId, $sendEmail, $sendSms, $siteId, $workShopId, $rdvCliWaits, $rdvActive, $rdvNoShowCustomer, $rdvMovementsComment, $vehStockNum, $rdvStoppedVehicle, $rdvStoppedIndicatorId, $receiverId, $contactCliId)
    {
        try {
            $this->setResult(self::getSoapClient()->setRdv($entId, $entKey, $rdvId, $rdvRONum, $dMSId, $siteCode, $receiverCode, $workshopCode, $cliDMSId, $vehVIN, $vehRegNum, $rdvType, $rdvDuration, $rdvState, $rdvPartsState, $rdvStart, $rdvFinish, $rdvReceivingComment, $rdvWorkshopComment, $rdvPartsComment, $rdvLoaner, $rdvSoldHours, $rdvWorkHours, $rdvSaleTotal, $rdvTicketNum, $workLineList, $providerName, $providerCliId, $providerVehId, $providerRdvId, $rdvBookedOnline, $vehId, $sendEmail, $sendSms, $siteId, $workShopId, $rdvCliWaits, $rdvActive, $rdvNoShowCustomer, $rdvMovementsComment, $vehStockNum, $rdvStoppedVehicle, $rdvStoppedIndicatorId, $receiverId, $contactCliId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setStaffCalendar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $siteId
     * @param string $siteCode
     * @param string $memId
     * @param string $memCode
     * @param string $absenceId
     * @param string $dateBegin
     * @param string $dateEnd
     * @param string $providerName
     * @return int|bool
     */
    public function setStaffCalendar($entId, $entKey, $dMSId, $siteId, $siteCode, $memId, $memCode, $absenceId, $dateBegin, $dateEnd, $providerName)
    {
        try {
            $this->setResult(self::getSoapClient()->setStaffCalendar($entId, $entKey, $dMSId, $siteId, $siteCode, $memId, $memCode, $absenceId, $dateBegin, $dateEnd, $providerName));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return int|\StructType\TWSResult
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
