<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Search ServiceType
 * @subpackage Services
 */
class Search extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named searchClient
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $cliName
     * @param string $cliDMSId
     * @param string $vehRegNum
     * @param string $vehVIN
     * @param string $cliTel
     * @param string $cliEmail
     * @param string $providerName
     * @param string $displayVehicles
     * @param string $searchOnlyByPhone
     * @return \StructType\TClient|bool
     */
    public function searchClient($entId, $entKey, $dMSId, $cliName, $cliDMSId, $vehRegNum, $vehVIN, $cliTel, $cliEmail, $providerName, $displayVehicles, $searchOnlyByPhone)
    {
        try {
            $this->setResult(self::getSoapClient()->searchClient($entId, $entKey, $dMSId, $cliName, $cliDMSId, $vehRegNum, $vehVIN, $cliTel, $cliEmail, $providerName, $displayVehicles, $searchOnlyByPhone));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TClient
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
