<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TUser StructType
 * @subpackage Structs
 */
class TUser extends AbstractStructBase
{
    /**
     * The UserId
     * @var int
     */
    public $UserId;
    /**
     * The UserName
     * @var string
     */
    public $UserName;
    /**
     * The UserCode
     * @var string
     */
    public $UserCode;
    /**
     * Constructor method for TUser
     * @uses TUser::setUserId()
     * @uses TUser::setUserName()
     * @uses TUser::setUserCode()
     * @param int $userId
     * @param string $userName
     * @param string $userCode
     */
    public function __construct($userId = null, $userName = null, $userCode = null)
    {
        $this
            ->setUserId($userId)
            ->setUserName($userName)
            ->setUserCode($userCode);
    }
    /**
     * Get UserId value
     * @return int|null
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param int $userId
     * @return \StructType\TUser
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: int
        if (!is_null($userId) && !is_numeric($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userId)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\TUser
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get UserCode value
     * @return string|null
     */
    public function getUserCode()
    {
        return $this->UserCode;
    }
    /**
     * Set UserCode value
     * @param string $userCode
     * @return \StructType\TUser
     */
    public function setUserCode($userCode = null)
    {
        // validation for constraint: string
        if (!is_null($userCode) && !is_string($userCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userCode)), __LINE__);
        }
        $this->UserCode = $userCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TUser
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
